/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.notification.implmail;

import j2html.TagCreator;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.jobkit.engine.SupervisableResult;
import tv.hd3g.mailkit.notification.implmail.HtmlCssDocumentPayload;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessage;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessageProducer;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessageProducerEnvironment;
import tv.hd3g.mailkit.notification.implmail.NotificationMailTemplateToolkit;

public class NotificationEngineMailTemplateSimple
implements NotificationMailMessageProducer {
    private final NotificationMailTemplateToolkit toolkit;

    public NotificationEngineMailTemplateSimple(NotificationMailTemplateToolkit toolkit) {
        this.toolkit = Objects.requireNonNull(toolkit, "\"toolkit\" can't to be null");
    }

    @Override
    public NotificationMailMessage makeMessage(NotificationMailMessageProducerEnvironment env, SupervisableEndEvent event) {
        return new NotificationMailMessage(this.toolkit.processSubject(env.lang(), event), this.toolkit.processHTMLMessage(this.assembleHTMLMessageBodyContent(env, event)));
    }

    private HtmlCssDocumentPayload assembleHTMLMessageBodyContent(NotificationMailMessageProducerEnvironment env, SupervisableEndEvent event) {
        SupervisableResult result;
        ArrayList<DomContent> listBodyContent = new ArrayList<DomContent>();
        ArrayList<String> listCSSEntries = new ArrayList<String>();
        this.toolkit.makeDocumentBaseStyles(listCSSEntries);
        if (event.error() != null) {
            this.toolkit.makeDocumentTitleError(env.lang(), event, listBodyContent, false, false);
        }
        if ((result = event.result()) != null) {
            this.toolkit.makeDocumentTitleWithResult(env.lang(), event, listBodyContent);
        } else if (event.error() == null) {
            this.toolkit.makeDocumentTitleWithoutResult(env.lang(), event, listBodyContent);
        }
        this.toolkit.makeDocumentSimpleContext(env.lang(), event, listBodyContent, listCSSEntries, env.sendAsSimpleNotificationContextPredicate());
        Optional.ofNullable(event.steps()).ifPresent(steps -> this.toolkit.stepsList(env.lang(), event, false, listBodyContent, listCSSEntries));
        listBodyContent.add((DomContent)TagCreator.hr());
        this.toolkit.makeDocumentFooter(listBodyContent, listCSSEntries);
        return new HtmlCssDocumentPayload(listBodyContent, listCSSEntries);
    }
}

