/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.jobkit.engine.SupervisableManager;
import tv.hd3g.mailkit.notification.NotificationRouter;

public class NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(NotificationManager.class);
    private final List<NotificationRouter> routers = Collections.synchronizedList(new ArrayList());

    public NotificationManager register(SupervisableManager supervisable) {
        Objects.requireNonNull(supervisable, "\"supervisable\" can't to be null");
        if (this.routers.isEmpty()) {
            throw new IllegalStateException("Can't register SupervisableManager: no Router is registed.");
        }
        log.info("Register SupervisableManager: {}", (Object)supervisable);
        supervisable.registerOnEndEventConsumer(event -> {
            log.trace("Send event to router(s): {}", (Object)event);
            this.routers.forEach(r -> r.send(event));
        });
        return this;
    }

    public NotificationManager register(NotificationRouter router) {
        Objects.requireNonNull(router, "\"router\" can't to be null");
        log.debug("Register NotificationRouter: {}", (Object)router);
        this.routers.add(router);
        return this;
    }
}

