/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.notification;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ExceptionToString {
    private final String newLine;

    public ExceptionToString() {
        this("\r\n");
    }

    public ExceptionToString(String newLine) {
        this.newLine = Objects.requireNonNull(newLine, "\"newLine\" can't to be null");
    }

    public String getStackTrace(Exception e) {
        CaptureWriter cw = new CaptureWriter();
        e.printStackTrace(cw);
        return cw.lines.toString();
    }

    public String getSimpleStackTrace(Exception e) {
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        ArrayList<String> lines = new ArrayList<String>();
        this.crawlInStackTrace(e, lines, "", dejaVu);
        return lines.stream().collect(Collectors.joining(this.newLine));
    }

    private void crawlInStackTrace(Throwable e, List<String> lines, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(e)) {
            return;
        }
        dejaVu.add(e);
        lines.add(prefix + e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
        Optional.ofNullable(e.getCause()).ifPresent(c -> this.crawlInStackTrace((Throwable)c, lines, " | ", dejaVu));
    }

    public static String exceptionRefCleaner(String line) {
        if (line == null) {
            return null;
        }
        return line.replace("java.util.concurrent.ExecutionException:", "").replace("java.io.UncheckedIOException:", "").replace("java.io.IOException:", "").replace("java.lang.NullPointerException:", "").replace("java.lang.IllegalStateException:", "").trim();
    }

    private class CaptureWriter
    extends PrintWriter {
        StringBuilder lines;

        public CaptureWriter() {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    throw new UnsupportedOperationException();
                }
            });
            this.lines = new StringBuilder();
        }

        @Override
        public void println(Object x) {
            String xValue = String.valueOf(x);
            if (xValue.equals(xValue.trim())) {
                this.lines.append(xValue);
            } else {
                this.lines.append(" ");
                this.lines.append(xValue.trim());
            }
            this.lines.append(ExceptionToString.this.newLine);
        }
    }
}

