/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.mod.service;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import tv.hd3g.commons.mailkit.SendMailDto;
import tv.hd3g.commons.mailkit.SendMailService;

@Service
public class SendMailServiceImpl
implements SendMailService {
    private static final Logger log = LoggerFactory.getLogger(SendMailServiceImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private TemplateEngine htmlTemplateEngine;
    @Autowired
    private TemplateEngine subjectTemplateEngine;

    public void sendEmail(SendMailDto sendMailDto) {
        try {
            this.internalSendEmail(sendMailDto);
        }
        catch (MessagingException e) {
            throw new RuntimeMessagingException(e);
        }
    }

    private void internalSendEmail(SendMailDto sendMailDto) throws MessagingException {
        Context ctx = new Context();
        ctx.setLocale(sendMailDto.getLang());
        ctx.setVariables(sendMailDto.getTemplateVars());
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, 3, "UTF-8");
        String subjectContent = this.subjectTemplateEngine.process(sendMailDto.getTemplateName(), (IContext)ctx).replace("\r\n", " ").replace("\n", " ").replace("    ", " ").replace("   ", " ").replace("  ", " ");
        message.setSubject(subjectContent);
        message.setFrom(sendMailDto.getSenderAddr());
        List recipients = sendMailDto.getRecipientsAddr();
        if (recipients.size() == 1) {
            message.setTo((String)recipients.get(0));
        } else {
            message.setTo(recipients.toArray(new String[0]));
        }
        this.setCcBccRecipients(sendMailDto, message);
        SortedSet attachedFiles = sendMailDto.getAttachedFiles();
        if (attachedFiles != null) {
            for (File file : attachedFiles) {
                message.addAttachment(file.getName(), file);
            }
        }
        if (sendMailDto.getReplyToAddr() != null) {
            message.setReplyTo(sendMailDto.getReplyToAddr());
        }
        if (sendMailDto.getGrade() != null) {
            message.setPriority(sendMailDto.getGrade().getMessagePriority());
        }
        mimeMessage.setHeader("User-Agent", "JavaMail/MailKit");
        mimeMessage.setHeader("Content-Language", sendMailDto.getLang().getLanguage());
        this.setReferenceHeaders(sendMailDto, mimeMessage);
        String htmlContent = this.htmlTemplateEngine.process(sendMailDto.getTemplateName(), (IContext)ctx);
        message.setText(htmlContent, true);
        Set resources = sendMailDto.getResourceFiles();
        if (resources != null) {
            for (String resource : resources) {
                ClassPathResource imageSource = new ClassPathResource("static/" + resource);
                message.addInline(resource, (Resource)imageSource);
            }
        }
        this.mailSender.send(mimeMessage);
        log.info("Send a mail to {}: \"{}\"", (Object)recipients.stream().collect(Collectors.joining(", ")), (Object)subjectContent);
        this.htmlTemplateEngine.clearTemplateCache();
    }

    private void setCcBccRecipients(SendMailDto sendMailDto, MimeMessageHelper message) throws MessagingException {
        List recipientsCC = sendMailDto.getRecipientsCCAddr();
        if (recipientsCC.size() == 1) {
            message.setCc((String)recipientsCC.get(0));
        } else if (!recipientsCC.isEmpty()) {
            message.setCc(recipientsCC.toArray(new String[0]));
        }
        List recipientsBCC = sendMailDto.getRecipientsBCCAddr();
        if (recipientsBCC.size() == 1) {
            message.setBcc((String)recipientsBCC.get(0));
        } else if (!recipientsBCC.isEmpty()) {
            message.setBcc(recipientsBCC.toArray(new String[0]));
        }
    }

    private void setReferenceHeaders(SendMailDto sendMailDto, MimeMessage mimeMessage) throws MessagingException {
        if (sendMailDto.getExternalReference() != null) {
            mimeMessage.setHeader("X-ExternalReference", sendMailDto.getExternalReference());
        }
        if (sendMailDto.getSenderReference() != null) {
            mimeMessage.setHeader("X-SenderReference", sendMailDto.getSenderReference());
        }
    }

    public static class RuntimeMessagingException
    extends RuntimeException {
        private RuntimeMessagingException(MessagingException e) {
            super((Throwable)e);
        }
    }
}

