/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.mod.configuration;

import java.util.Optional;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.spring6.messageresolver.SpringMessageResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import tv.hd3g.commons.version.EnvironmentVersion;
import tv.hd3g.jobkit.engine.SupervisableManager;
import tv.hd3g.mailkit.mod.component.Translate;
import tv.hd3g.mailkit.mod.configuration.MailKitConfig;
import tv.hd3g.mailkit.mod.service.AppNotificationService;
import tv.hd3g.mailkit.notification.NotificationManager;
import tv.hd3g.mailkit.notification.implmail.NotificationEngineMailSetup;
import tv.hd3g.mailkit.notification.implmail.NotificationEngineMailTemplateDebug;
import tv.hd3g.mailkit.notification.implmail.NotificationEngineMailTemplateFull;
import tv.hd3g.mailkit.notification.implmail.NotificationEngineMailTemplateSimple;
import tv.hd3g.mailkit.notification.implmail.NotificationMailTemplateToolkit;
import tv.hd3g.mailkit.notification.implmail.NotificationRouterMail;

@Configuration
@ComponentScan(basePackages={"tv.hd3g.commons.version.mod"})
public class MailKitSetup {
    @Bean
    @Primary
    ResourceBundleMessageSource resourceBundleMessageSource() {
        ResourceBundleMessageSource rbms = new ResourceBundleMessageSource();
        rbms.addBasenames(new String[]{"mailkit-messages"});
        return rbms;
    }

    @Bean
    SpringMessageResolver getSpringMessageResolver(MessageSource rbms) {
        SpringMessageResolver springMessageResolver = new SpringMessageResolver();
        springMessageResolver.setMessageSource(rbms);
        return springMessageResolver;
    }

    private ITemplateResolver templateResolver(String suffix, TemplateMode mode) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix("/templates/");
        templateResolver.setSuffix(suffix);
        templateResolver.setTemplateMode(mode);
        templateResolver.setCharacterEncoding("UTF8");
        templateResolver.setCheckExistence(true);
        templateResolver.setCacheable(false);
        return templateResolver;
    }

    @Bean(name={"htmlTemplateEngine"})
    TemplateEngine htmlTemplateEngine(SpringMessageResolver springMessageResolver) {
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.addTemplateResolver(this.templateResolver(".html", TemplateMode.HTML));
        templateEngine.addMessageResolver((IMessageResolver)springMessageResolver);
        return templateEngine;
    }

    @Bean(name={"subjectTemplateEngine"})
    TemplateEngine subjectTemplateEngine(SpringMessageResolver springMessageResolver) {
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.addTemplateResolver(this.templateResolver(".txt", TemplateMode.TEXT));
        templateEngine.addMessageResolver((IMessageResolver)springMessageResolver);
        return templateEngine;
    }

    @Bean
    NotificationManager getNotificationManager(ResourceBundleMessageSource rbms, AppNotificationService appNotificationService, MailKitConfig config, JavaMailSender mailSender, Translate translate, SupervisableManager supervisableManager, EnvironmentVersion environmentVersion) {
        Optional.ofNullable(appNotificationService.getMessageSourceBasename()).ifPresent(xva$0 -> rbms.addBasenames(new String[]{xva$0}));
        NotificationMailTemplateToolkit toolkit = new NotificationMailTemplateToolkit(translate, config.getEnv(), environmentVersion);
        NotificationEngineMailSetup setupEngine = new NotificationEngineMailSetup(supervisableManager, appNotificationService, mailSender, config.getSenderAddr(), Optional.ofNullable(config.getReplyToAddr()).orElse(config.getSenderAddr()), config.getGroupDev(), config.getGroupAdmin(), config.getGroupSecurity());
        NotificationRouterMail router = new NotificationRouterMail(new NotificationEngineMailTemplateSimple(toolkit), new NotificationEngineMailTemplateFull(toolkit), new NotificationEngineMailTemplateDebug(toolkit), setupEngine);
        return new NotificationManager().register(router).register(supervisableManager);
    }
}

