/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.mod.component;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.stereotype.Component;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.mailkit.mod.configuration.MailKitConfig;

@Component
public class Translate {
    private static final Logger log = LoggerFactory.getLogger(Translate.class);
    private static final String MAILKIT_NOTIFICATION = "mailkit.notification.";
    private static ConcurrentMap<Locale, Properties> messagesFiles = new ConcurrentHashMap<Locale, Properties>();
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MailKitConfig conf;

    @PostConstruct
    void init() throws IOException {
        if (this.conf.getSaveMissingMessages() == null) {
            return;
        }
        if (!this.conf.getSaveMissingMessages().exists()) {
            FileUtils.forceMkdir((File)this.conf.getSaveMissingMessages());
        }
    }

    String makeKeyByEvent(String eventTypeName, String code) {
        return MAILKIT_NOTIFICATION + eventTypeName.toLowerCase() + "." + code.toLowerCase();
    }

    public String i18n(Locale lang, SupervisableEndEvent event, String code, String defaultResult, String ... vars) {
        return this.i18n(lang, event.typeName(), code, defaultResult, vars);
    }

    public String i18n(Locale lang, String rawEventTypeName, String rawCode, String defaultResult, String ... vars) {
        String eventTypeName = rawEventTypeName.toLowerCase();
        String code = rawCode.toLowerCase();
        String keyByEvent = this.makeKeyByEvent(eventTypeName, code);
        try {
            return this.messageSource.getMessage(keyByEvent, (Object[])vars, lang);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            if (defaultResult.contains("{}")) {
                throw new IllegalArgumentException("Never use \"{}\" as defaultResult on \"" + eventTypeName + "." + code + "\", always add a number like {0}");
            }
            String keyDefault = MAILKIT_NOTIFICATION + code;
            try {
                return this.messageSource.getMessage(keyDefault, (Object[])vars, lang);
            }
            catch (NoSuchMessageException e) {
                String key = eventTypeName.isEmpty() ? MAILKIT_NOTIFICATION + code : "mailkit.notification.(" + eventTypeName + ")." + code;
                log.warn("Can't resolve message code \"{}\" [{}], set by default: \"{}\"", new Object[]{key, lang, defaultResult});
                this.appendI18nMissingMessageFile(lang, keyDefault, defaultResult);
                return this.messageSource.getMessage(keyDefault, (Object[])vars, defaultResult, lang);
            }
        }
    }

    File getMissingMessageFile(Locale lang) {
        return new File(this.conf.getSaveMissingMessages(), "example-messages_" + lang.toString() + ".properties");
    }

    private void appendI18nMissingMessageFile(Locale lang, String keyDefault, String defaultResult) {
        if (this.conf.getSaveMissingMessages() == null) {
            return;
        }
        Properties messages = messagesFiles.computeIfAbsent(lang, l -> new Properties());
        Object previous = messages.putIfAbsent(keyDefault, defaultResult);
        if (previous != null) {
            return;
        }
        File messageFile = this.getMissingMessageFile(lang);
        log.info("Write to \"{}\" missing file...", (Object)messageFile.getAbsolutePath());
        try (FileWriter fw = new FileWriter(messageFile);){
            messages.store(fw, "Automatically generated by " + this.getClass().getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't write to example messageFile", e);
        }
    }
}

