/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tv.hd3g.commons.authkit.CheckBefore;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.mod.BackgroundServiceId;
import tv.hd3g.jobkit.mod.dto.BackgroundServiceIdDto;
import tv.hd3g.jobkit.mod.dto.JobKitEngineStatusDto;

@RestController
@CheckBefore(value={"jobkitState"})
@RequestMapping(value={"/v1/jobkit/state"}, produces={"application/json"})
public class JobKitStateController {
    @Autowired
    private JobKitEngine jobKitEngine;
    @Autowired
    private BackgroundServiceId backgroundServiceId;

    @GetMapping(value={"status"})
    @CheckBefore(value={"jobkitStatus"})
    public ResponseEntity<JobKitEngineStatusDto> getLastStatus() {
        JobKitEngineStatusDto result = new JobKitEngineStatusDto(this.jobKitEngine.getLastStatus());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"ids"})
    @CheckBefore(value={"jobkitStatus"})
    public ResponseEntity<BackgroundServiceIdDto> getIds() {
        BackgroundServiceIdDto result = this.backgroundServiceId.getAllRegistedAsDto();
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

