/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import tv.hd3g.jobkit.engine.BackgroundService;
import tv.hd3g.jobkit.engine.status.BackgroundServiceStatus;
import tv.hd3g.jobkit.mod.dto.BackgroundServiceIdDto;

public class BackgroundServiceId {
    private final ConcurrentHashMap<UUID, BackgroundService> serviceMap = new ConcurrentHashMap();

    public UUID register(BackgroundService service) {
        UUID key = UUID.randomUUID();
        this.serviceMap.put(key, service);
        return key;
    }

    public BackgroundService unRegister(UUID uuid) {
        return this.serviceMap.remove(uuid);
    }

    public BackgroundServiceIdDto getAllRegistedAsDto() {
        return new BackgroundServiceIdDto(this.serviceMap.entrySet().stream().map(entry -> {
            BackgroundServiceStatus lastStatus = ((BackgroundService)entry.getValue()).getLastStatus();
            return new BackgroundServiceIdDto.Item((UUID)entry.getKey(), lastStatus.getName(), lastStatus.getSpoolName());
        }).collect(Collectors.toUnmodifiableSet()));
    }

    public BackgroundService getByUUID(UUID uuid) {
        return this.serviceMap.get(uuid);
    }

    public void forEach(Consumer<BackgroundService> action) {
        this.serviceMap.values().forEach(action);
    }
}

