/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod.controller;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tv.hd3g.commons.authkit.CheckBefore;
import tv.hd3g.jobkit.engine.BackgroundService;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.mod.BackgroundServiceId;
import tv.hd3g.jobkit.mod.exception.JobKitRestException;

@RestController
@CheckBefore(value={"jobkitAction"})
@RequestMapping(value={"/v1/jobkit/action"}, produces={"application/json"})
@Validated
public class JobKitActionController {
    @Autowired
    private JobKitEngine jobKitEngine;
    @Autowired
    private BackgroundServiceId backgroundServiceId;

    @PutMapping(value={"{uuid}/enable"})
    public ResponseEntity<Object> enable(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.getBackgroundServiceByUUID(uuid).enable();
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"{uuid}/disable"})
    public ResponseEntity<Object> disable(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.getBackgroundServiceByUUID(uuid).disable();
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"{uuid}/timed-interval/{duration}"})
    public ResponseEntity<Object> setTimedInterval(@PathVariable(value="uuid") @NotEmpty String uuid, @PathVariable(value="duration") @Positive long duration) {
        this.getBackgroundServiceByUUID(uuid).setTimedInterval(Duration.of(duration, ChronoUnit.SECONDS));
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"{uuid}/priority/{priority}"})
    public ResponseEntity<Object> setPriority(@PathVariable(value="uuid") @NotEmpty String uuid, @PathVariable(value="priority") @NotNull int priority) {
        this.getBackgroundServiceByUUID(uuid).setPriority(priority);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"{uuid}/retry-after-time-factor/{factor}"})
    public ResponseEntity<Object> setRetryAfterTimeFactor(@PathVariable(value="uuid") @NotEmpty String uuid, @PathVariable(value="factor") @Positive double factor) {
        this.getBackgroundServiceByUUID(uuid).setRetryAfterTimeFactor(factor);
        return new ResponseEntity(HttpStatus.OK);
    }

    private BackgroundService getBackgroundServiceByUUID(String uuid) {
        return Optional.ofNullable(this.backgroundServiceId.getByUUID(UUID.fromString(uuid))).orElseThrow(() -> new JobKitRestException(404, "Can't found this service UUID"));
    }

    @PutMapping(value={"all/enable"})
    public ResponseEntity<Object> enableAll() {
        this.backgroundServiceId.forEach(BackgroundService::enable);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"all/disable"})
    public ResponseEntity<Object> disableAll() {
        this.backgroundServiceId.forEach(BackgroundService::disable);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(value={"shutdown"})
    public ResponseEntity<Object> shutdown() {
        this.jobKitEngine.shutdown();
        return new ResponseEntity(HttpStatus.OK);
    }
}

