/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import tv.hd3g.jobkit.mod.dto.RegularProcessRunnerDto;
import tv.hd3g.jobkit.mod.dto.RegularProcessRunnerListDto;

@Configuration
@ConfigurationProperties(prefix="jobkit.processrunners")
@Validated
public class RegularProcessRunnersConfigurer {
    private List<RegularProcessRunnerEntry> services;
    private Set<RegularProcessRunnerDto> servicesDto;
    private String sendFrom;
    private String replyTo;
    private String senderReference;
    private List<String> execPath;
    private List<String> sendToAdmin;
    private String defaultTemplateNameDone;
    private String defaultTemplateNameError;
    private boolean disabledAtStart;

    public List<RegularProcessRunnerEntry> getServices() {
        return this.services;
    }

    public void setServices(List<RegularProcessRunnerEntry> services) {
        this.services = services;
    }

    public String getSendFrom() {
        return this.sendFrom;
    }

    public void setSendFrom(String sendFrom) {
        this.sendFrom = sendFrom;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getSenderReference() {
        return this.senderReference;
    }

    public void setSenderReference(String senderReference) {
        this.senderReference = senderReference;
    }

    public List<String> getExecPath() {
        return this.execPath;
    }

    public void setExecPath(List<String> execPath) {
        this.execPath = execPath;
    }

    public List<String> getSendToAdmin() {
        return this.sendToAdmin;
    }

    public void setSendToAdmin(List<String> sendToAdmin) {
        this.sendToAdmin = sendToAdmin;
    }

    public String getDefaultTemplateNameDone() {
        return this.defaultTemplateNameDone;
    }

    public String getDefaultTemplateNameError() {
        return this.defaultTemplateNameError;
    }

    public void setDefaultTemplateNameDone(String defaultTemplateNameDone) {
        this.defaultTemplateNameDone = defaultTemplateNameDone;
    }

    public void setDefaultTemplateNameError(String defaultTemplateNameError) {
        this.defaultTemplateNameError = defaultTemplateNameError;
    }

    public void setServicesDto(Set<RegularProcessRunnerDto> servicesDto) {
        this.servicesDto = servicesDto;
    }

    public RegularProcessRunnerListDto makeConfigurationDto() {
        return new RegularProcessRunnerListDto(this.servicesDto, this.execPath, this.senderReference);
    }

    public void setDisabledAtStart(boolean disabledAtStart) {
        this.disabledAtStart = disabledAtStart;
    }

    public boolean isDisabledAtStart() {
        return this.disabledAtStart;
    }

    @Validated
    public static class RegularProcessRunnerEntry {
        @NotEmpty
        private String name;
        @NotEmpty
        private String spoolName;
        private String comment;
        @NotNull
        private Duration periodTime;
        private int priority;
        private double retryAfterTimeFactor;
        private boolean runFirstAtBoot;
        @NotEmpty
        private String commandLine;
        private Map<String, String> env;
        private File workingDir;
        private AfterExecEntry afterDone;
        private AfterExecEntry afterError;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSpoolName() {
            return this.spoolName;
        }

        public void setSpoolName(String spoolName) {
            this.spoolName = spoolName;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Duration getPeriodTime() {
            return this.periodTime;
        }

        public void setPeriodTime(Duration periodTime) {
            this.periodTime = periodTime;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public double getRetryAfterTimeFactor() {
            return this.retryAfterTimeFactor;
        }

        public void setRetryAfterTimeFactor(double retryAfterTimeFactor) {
            this.retryAfterTimeFactor = retryAfterTimeFactor;
        }

        public boolean isRunFirstAtBoot() {
            return this.runFirstAtBoot;
        }

        public void setRunFirstAtBoot(boolean runFirstAtBoot) {
            this.runFirstAtBoot = runFirstAtBoot;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public void setCommandLine(String commandLine) {
            this.commandLine = commandLine;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public void setEnv(Map<String, String> env) {
            this.env = env;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(File workingDir) {
            this.workingDir = workingDir;
        }

        public AfterExecEntry getAfterDone() {
            return this.afterDone;
        }

        public void setAfterDone(AfterExecEntry afterDone) {
            this.afterDone = afterDone;
        }

        public AfterExecEntry getAfterError() {
            return this.afterError;
        }

        public void setAfterError(AfterExecEntry afterError) {
            this.afterError = afterError;
        }

        public static class AfterExecEntry {
            private List<String> sendTo;
            private List<String> sendCc;
            private String replyTo;
            private String templateName;
            private Locale lang;
            private Map<String, Object> addToTemplateVars;

            public List<String> getSendTo() {
                return this.sendTo;
            }

            public void setSendTo(List<String> sendTo) {
                this.sendTo = sendTo;
            }

            public List<String> getSendCc() {
                return this.sendCc;
            }

            public void setSendCc(List<String> sendCc) {
                this.sendCc = sendCc;
            }

            public String getReplyTo() {
                return this.replyTo;
            }

            public void setReplyTo(String replyTo) {
                this.replyTo = replyTo;
            }

            public String getTemplateName() {
                return this.templateName;
            }

            public void setTemplateName(String templateName) {
                this.templateName = templateName;
            }

            public Locale getLang() {
                return this.lang;
            }

            public void setLang(Locale lang) {
                this.lang = lang;
            }

            public Map<String, Object> getAddToTemplateVars() {
                return this.addToTemplateVars;
            }

            public void setAddToTemplateVars(Map<String, Object> addToTemplateVars) {
                this.addToTemplateVars = addToTemplateVars;
            }
        }
    }
}

