/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import tv.hd3g.jobkit.engine.watchdog.LimitedExecTimePolicy;
import tv.hd3g.jobkit.engine.watchdog.LimitedServiceExecTimePolicy;
import tv.hd3g.jobkit.engine.watchdog.MaxSpoolQueueSizePolicy;

@Configuration
@ConfigurationProperties(prefix="jobkit.watchdogpolicies")
public class JobKitWatchdogConfig {
    private List<MaxSpoolQueueSizePolicy> maxSpoolQueueSize;
    private List<LimitedExecTimePolicy> limitedExecTime;
    private List<LimitedServiceExecTimePolicy> limitedServiceExecTime;

    @PostConstruct
    void init() {
        this.maxSpoolQueueSize = Optional.ofNullable(this.maxSpoolQueueSize).orElse(new ArrayList());
        this.limitedExecTime = Optional.ofNullable(this.limitedExecTime).orElse(new ArrayList());
        this.limitedServiceExecTime = Optional.ofNullable(this.limitedServiceExecTime).orElse(new ArrayList());
    }

    public List<MaxSpoolQueueSizePolicy> getMaxSpoolQueueSize() {
        return this.maxSpoolQueueSize;
    }

    public List<LimitedExecTimePolicy> getLimitedExecTime() {
        return this.limitedExecTime;
    }

    public List<LimitedServiceExecTimePolicy> getLimitedServiceExecTime() {
        return this.limitedServiceExecTime;
    }

    public void setMaxSpoolQueueSize(List<MaxSpoolQueueSizePolicy> maxSpoolQueueSize) {
        this.maxSpoolQueueSize = maxSpoolQueueSize;
    }

    public void setLimitedExecTime(List<LimitedExecTimePolicy> limitedExecTime) {
        this.limitedExecTime = limitedExecTime;
    }

    public void setLimitedServiceExecTime(List<LimitedServiceExecTimePolicy> limitedServiceExecTime) {
        this.limitedServiceExecTime = limitedServiceExecTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobKitWatchdogConfig)) {
            return false;
        }
        JobKitWatchdogConfig other = (JobKitWatchdogConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaxSpoolQueueSizePolicy> this$maxSpoolQueueSize = this.getMaxSpoolQueueSize();
        List<MaxSpoolQueueSizePolicy> other$maxSpoolQueueSize = other.getMaxSpoolQueueSize();
        if (this$maxSpoolQueueSize == null ? other$maxSpoolQueueSize != null : !((Object)this$maxSpoolQueueSize).equals(other$maxSpoolQueueSize)) {
            return false;
        }
        List<LimitedExecTimePolicy> this$limitedExecTime = this.getLimitedExecTime();
        List<LimitedExecTimePolicy> other$limitedExecTime = other.getLimitedExecTime();
        if (this$limitedExecTime == null ? other$limitedExecTime != null : !((Object)this$limitedExecTime).equals(other$limitedExecTime)) {
            return false;
        }
        List<LimitedServiceExecTimePolicy> this$limitedServiceExecTime = this.getLimitedServiceExecTime();
        List<LimitedServiceExecTimePolicy> other$limitedServiceExecTime = other.getLimitedServiceExecTime();
        return !(this$limitedServiceExecTime == null ? other$limitedServiceExecTime != null : !((Object)this$limitedServiceExecTime).equals(other$limitedServiceExecTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobKitWatchdogConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaxSpoolQueueSizePolicy> $maxSpoolQueueSize = this.getMaxSpoolQueueSize();
        result = result * 59 + ($maxSpoolQueueSize == null ? 43 : ((Object)$maxSpoolQueueSize).hashCode());
        List<LimitedExecTimePolicy> $limitedExecTime = this.getLimitedExecTime();
        result = result * 59 + ($limitedExecTime == null ? 43 : ((Object)$limitedExecTime).hashCode());
        List<LimitedServiceExecTimePolicy> $limitedServiceExecTime = this.getLimitedServiceExecTime();
        result = result * 59 + ($limitedServiceExecTime == null ? 43 : ((Object)$limitedServiceExecTime).hashCode());
        return result;
    }

    public String toString() {
        return "JobKitWatchdogConfig(maxSpoolQueueSize=" + this.getMaxSpoolQueueSize() + ", limitedExecTime=" + this.getLimitedExecTime() + ", limitedServiceExecTime=" + this.getLimitedServiceExecTime() + ")";
    }
}

