/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.engine.RunnableWithException;

@Configuration
@EnableAsync
public class JobKitAsyncConfigurer
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(JobKitAsyncConfigurer.class);
    public static final String POOL_NAME = "springboot";
    @Autowired
    JobKitEngine jobKitEngine;

    public Executor getAsyncExecutor() {
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss,S");
        return task -> {
            String dateText = LocalDateTime.now().format(pattern);
            boolean sended = this.jobKitEngine.runOneShot("SpringBoot Async " + dateText, POOL_NAME, 0, RunnableWithException.fromRunnable((Runnable)task), e -> {
                if (e != null) {
                    log.error("Can't execute SpringBootAsync task", (Throwable)e);
                }
            });
            if (!sended) {
                log.error("Can't queue new @async executor task, jobKitEngine refuse new jobs");
            }
        };
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (e, method, params) -> {
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            String fullParams = Stream.of(method.getParameters()).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining(", "));
            log.error("UncaughtException during SpringBootAsync task: {}.{}({})", new Object[]{className, methodName, fullParams, e});
        };
    }
}

