/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod.component;

import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;
import tv.hd3g.jobkit.WithSupervisable;
import tv.hd3g.jobkit.engine.Supervisable;
import tv.hd3g.jobkit.engine.SupervisableServiceSupplier;

@Aspect
@Component
@EnableAspectJAutoProxy
public class SupervisableAspect {
    @Autowired
    private SupervisableServiceSupplier supervisableServiceSupplier;

    @Around(value="annotationWithSupervisable()")
    public Object manageSupervisable(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            Supervisable.getSupervisable();
            return joinPoint.proceed(joinPoint.getArgs());
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            Object jobName = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(WithSupervisable.class).value();
            if (((String)jobName).isEmpty()) {
                jobName = joinPoint.getSignature().getDeclaringType().getSimpleName() + "." + joinPoint.getSignature().getName();
            }
            Supervisable supervisable = this.supervisableServiceSupplier.createAndStart((String)jobName);
            try {
                Object result = joinPoint.proceed(joinPoint.getArgs());
                this.supervisableServiceSupplier.end(supervisable, Optional.empty());
                return result;
            }
            catch (Exception e) {
                this.supervisableServiceSupplier.end(supervisable, Optional.ofNullable(e));
                throw e;
            }
        }
    }

    @Pointcut(value="@annotation(tv.hd3g.jobkit.WithSupervisable)")
    public void annotationWithSupervisable() {
    }
}

