/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import tv.hd3g.jobkit.engine.BackgroundServiceEvent;
import tv.hd3g.jobkit.engine.ExecutionEvent;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.engine.SupervisableManager;
import tv.hd3g.jobkit.engine.SupervisableServiceSupplier;

@Configuration
public class JobKitSetup {
    private static final Logger log = LogManager.getLogger();
    @Value(value="${jobkit.supervisable.maxEndEventsRetention:100}")
    private int maxEndEventsRetention;

    @Bean
    ScheduledExecutorService getScheduledExecutor() {
        return new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(false);
            t.setPriority(2);
            t.setName("SchTaskStarter");
            t.setUncaughtExceptionHandler((thrd, e) -> log.fatal("Regular scheduled thread have an uncaught error", e));
            return t;
        });
    }

    @Bean
    public SupervisableManager getSupervisableManager(ApplicationContext applicationContext, ObjectMapper jacksonObjectMapper) {
        String appName = applicationContext.getApplicationName();
        if (appName.isEmpty()) {
            appName = "Default";
        }
        String env = Optional.ofNullable(applicationContext.getEnvironment()).map(Environment::getActiveProfiles).map(List::of).map(Collection::stream).map(s -> s.collect(Collectors.joining(", "))).orElse("");
        return new SupervisableManager((appName + " " + env).trim(), jacksonObjectMapper, this.maxEndEventsRetention);
    }

    @Bean
    public SupervisableServiceSupplier getSupervisableSupplier(SupervisableManager supervisableManager) {
        return new SupervisableServiceSupplier(supervisableManager);
    }

    @Bean
    @Autowired
    JobKitEngine getJobKitEngine(ScheduledExecutorService scheduledExecutor, ExecutionEvent executionEvent, BackgroundServiceEvent backgroundServiceEvent, SupervisableManager supervisableManager) {
        return new JobKitEngine(scheduledExecutor, executionEvent, backgroundServiceEvent, supervisableManager);
    }
}

