/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.mod.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tv.hd3g.commons.mailkit.SendMailDto;
import tv.hd3g.commons.mailkit.SendMailService;
import tv.hd3g.jobkit.engine.BackgroundService;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.mod.BackgroundServiceId;
import tv.hd3g.jobkit.mod.RegularProcessRunnersConfigurer;
import tv.hd3g.jobkit.mod.dto.RegularProcessRunnerDto;
import tv.hd3g.jobkit.mod.service.ExecFactoryService;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.Exec;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;

@Service
public class RegularProcessRunnerServiceImpl
implements InitializingBean,
DisposableBean {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ExecutableFinder executableFinder;
    @Autowired
    private ScheduledExecutorService scheduledExecutorService;
    @Autowired
    private JobKitEngine jobKitEngine;
    @Autowired
    private RegularProcessRunnersConfigurer regularProcessRunnersConfigurer;
    @Autowired
    private SendMailService sendMailService;
    @Autowired
    private BackgroundServiceId backgroundServiceId;
    @Autowired
    private ExecFactoryService execFactoryService;

    public void afterPropertiesSet() throws Exception {
        if (!this.regularProcessRunnersConfigurer.isDisabledAtStart()) {
            this.start();
        } else if (this.regularProcessRunnersConfigurer.getServices() != null && !this.regularProcessRunnersConfigurer.getServices().isEmpty()) {
            log.info("Don't start service RegularProcessRunner");
        }
    }

    public void start() throws FileNotFoundException {
        List<RegularProcessRunnersConfigurer.RegularProcessRunnerEntry> services = this.regularProcessRunnersConfigurer.getServices();
        if (services == null || services.isEmpty()) {
            log.warn("No configured services to start for RegularProcessRunner");
            return;
        }
        log.info("Init service RegularProcessRunner for {} services", (Object)services.size());
        if (this.regularProcessRunnersConfigurer.getSendFrom() == null) {
            log.info("No senderAddr configured for regularProcessRunners: cancel mail sends");
        }
        ArrayList onErrors = new ArrayList();
        services.forEach(runnerConf -> {
            int firstSpacePos = runnerConf.getCommandLine().indexOf(32);
            try {
                if (firstSpacePos < 1) {
                    this.executableFinder.get(runnerConf.getCommandLine().trim());
                } else {
                    this.executableFinder.get(runnerConf.getCommandLine().substring(0, firstSpacePos).trim());
                }
            }
            catch (FileNotFoundException e) {
                log.fatal("Check service \"{}\" configuration", (Object)runnerConf.getName(), (Object)e);
                onErrors.add(runnerConf);
            }
        });
        if (!onErrors.isEmpty()) {
            log.fatal("Service RegularProcessRunners configuration error, please check current PATH and conf execPath");
            throw new FileNotFoundException("Can't found some executables declared by RegularProcessRunners: " + onErrors.stream().map(RegularProcessRunnersConfigurer.RegularProcessRunnerEntry::getName).collect(Collectors.joining(", ")));
        }
        services.forEach(runnerConf -> {
            if (runnerConf.getWorkingDir() != null && !runnerConf.getWorkingDir().exists()) {
                onErrors.add(runnerConf);
            }
        });
        if (!onErrors.isEmpty()) {
            log.fatal("Service RegularProcessRunners configuration error, please check workingDir paths");
            throw new FileNotFoundException("Can't access to workingDir declared by RegularProcessRunners: " + onErrors.stream().map(RegularProcessRunnersConfigurer.RegularProcessRunnerEntry::getName).collect(Collectors.joining(", ")));
        }
        Set<RegularProcessRunnerDto> servicesDto = services.stream().map(this::startService).collect(Collectors.toUnmodifiableSet());
        this.regularProcessRunnersConfigurer.setServicesDto(servicesDto);
        log.debug("Ends of init service RegularProcessRunner");
    }

    private RegularProcessRunnerDto startService(RegularProcessRunnersConfigurer.RegularProcessRunnerEntry runnerConf) {
        String commandLine;
        String execName;
        int firstSpacePos = runnerConf.getCommandLine().indexOf(32);
        if (firstSpacePos < 1) {
            execName = runnerConf.getCommandLine().trim();
            commandLine = "";
        } else {
            execName = runnerConf.getCommandLine().substring(0, firstSpacePos).trim();
            commandLine = runnerConf.getCommandLine().substring(firstSpacePos).trim();
        }
        Exec exec = this.execFactoryService.createNewExec(execName);
        exec.getParameters().clear().addBulkParameters(commandLine);
        Task task = new Task(runnerConf, exec);
        BackgroundService service = this.jobKitEngine.startService(runnerConf.getName(), runnerConf.getSpoolName(), runnerConf.getPeriodTime(), (Runnable)task);
        service.setPriority(runnerConf.getPriority());
        if (runnerConf.getRetryAfterTimeFactor() > 1.0) {
            service.setRetryAfterTimeFactor(runnerConf.getRetryAfterTimeFactor());
        }
        this.backgroundServiceId.register(service);
        if (runnerConf.isRunFirstAtBoot()) {
            this.jobKitEngine.runOneShot(runnerConf.getName(), runnerConf.getSpoolName(), runnerConf.getPriority(), (Runnable)task, e -> {});
        }
        return new RegularProcessRunnerDto(runnerConf.getName(), runnerConf.getSpoolName(), runnerConf.getComment(), (exec.getExecutableName() + " " + exec.getReadyToRunParameters().toString()).trim(), Optional.ofNullable(runnerConf.getEnv()).orElse(Map.of()).keySet(), runnerConf.getWorkingDir());
    }

    public void destroy() throws Exception {
        this.jobKitEngine.shutdown();
        this.scheduledExecutorService.shutdownNow();
        this.jobKitEngine.waitToClose();
    }

    public class Task
    implements Runnable {
        private final RegularProcessRunnersConfigurer.RegularProcessRunnerEntry runnerConf;
        private final Map<String, String> env;
        private final Consumer<ProcesslauncherBuilder> beforeRun;
        private final Exec exec;
        private final File execFile;
        private final String execName;

        Task(RegularProcessRunnersConfigurer.RegularProcessRunnerEntry runnerConf, Exec exec) {
            this.runnerConf = runnerConf;
            this.exec = exec;
            this.execName = exec.getExecutableName();
            this.execFile = exec.getExecutableFile();
            this.env = Optional.ofNullable(runnerConf.getEnv()).orElse(Map.of());
            File workingDirectory = runnerConf.getWorkingDir();
            this.beforeRun = pbuilder -> {
                this.env.forEach((arg_0, arg_1) -> ((ProcesslauncherBuilder)pbuilder).setEnvironmentVar(arg_0, arg_1));
                if (workingDirectory != null) {
                    try {
                        pbuilder.setWorkingDirectory(workingDirectory);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid workingDirectory for " + runnerConf.getName(), e);
                    }
                }
            };
        }

        @Override
        public void run() {
            CapturedStdOutErrTextRetention result;
            try {
                log.info("Start process {}, in {}/{}", (Object)this.execName, (Object)this.runnerConf.getSpoolName(), (Object)this.runnerConf.getName());
                result = this.exec.runWaitGetText(this.beforeRun);
            }
            catch (Exception e) {
                log.error("Execution error for {} used by {}", (Object)this.execName, (Object)this.runnerConf.getName(), (Object)e);
                this.sendMailNotification(null, e, this.runnerConf.getAfterError());
                throw new ProcessExecutionException((Throwable)e);
            }
            log.info("Process {} ends, in {}/{}", (Object)this.execName, (Object)this.runnerConf.getSpoolName(), (Object)this.runnerConf.getName());
            this.sendMailNotification(result, null, this.runnerConf.getAfterDone());
        }

        private void sendMailNotification(CapturedStdOutErrTextRetention output, Exception error, RegularProcessRunnersConfigurer.RegularProcessRunnerEntry.AfterExecEntry providedMailConf) {
            RegularProcessRunnersConfigurer.RegularProcessRunnerEntry.AfterExecEntry mailConf;
            if (providedMailConf == null && error != null) {
                mailConf = new RegularProcessRunnersConfigurer.RegularProcessRunnerEntry.AfterExecEntry();
            } else {
                if (providedMailConf == null) {
                    return;
                }
                mailConf = providedMailConf;
            }
            String senderAddr = RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getSendFrom();
            if (senderAddr == null) {
                return;
            }
            String templateName = error == null ? this.optional(mailConf.getTemplateName(), RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getDefaultTemplateNameDone(), "jobkit-regular-process-runner-default-mail") : this.optional(mailConf.getTemplateName(), RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getDefaultTemplateNameError(), "jobkit-regular-process-runner-error-mail");
            Stream configuredVarsStream = Optional.ofNullable(mailConf.getAddToTemplateVars()).orElse(Map.of()).entrySet().stream();
            Stream mailVarsStream = Map.of("serviceName", this.runnerConf.getName(), "spoolName", this.runnerConf.getSpoolName(), "comment", (Serializable)((Object)Optional.ofNullable(this.runnerConf.getComment()).orElse("")), "execName", this.exec.getExecutableName(), "execFile", this.execFile, "commandLine", this.exec.getReadyToRunParameters().toString(), "workingDir", (Serializable)((Object)Optional.ofNullable(this.runnerConf.getWorkingDir()).map(File::getPath).orElse("")), "stdout", (Serializable)((Object)Optional.ofNullable(output).map(captureOutput -> captureOutput.getStdout(false, System.lineSeparator())).orElse("")), "stderr", (Serializable)((Object)Optional.ofNullable(output).map(captureOutput -> captureOutput.getStderr(false, System.lineSeparator())).orElse("")), "stackTrace", (Serializable)((Object)Optional.ofNullable(error).map(e -> {
                StringWriter swException = new StringWriter();
                PrintWriter pwException = new PrintWriter(swException);
                error.printStackTrace(pwException);
                return swException.getBuffer().toString();
            }).orElse(""))).entrySet().stream();
            Map<String, Object> templateVars = Stream.concat(configuredVarsStream, mailVarsStream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, r) -> r));
            List sendToAdmin = error != null ? Optional.ofNullable(RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getSendToAdmin()).orElse(List.of()) : List.of();
            List recipientsAddr = Optional.ofNullable(mailConf.getSendTo()).orElse(sendToAdmin);
            if (recipientsAddr.isEmpty()) {
                throw new IllegalStateException("No A recipients to send this message, check conf for jobkit " + this.runnerConf.getName());
            }
            List recipientsCCAddr = Optional.ofNullable(mailConf.getSendCc()).orElseGet(() -> sendToAdmin.stream().filter(addr -> !recipientsAddr.contains(addr)).collect(Collectors.toUnmodifiableList()));
            List recipientsBCCAddr = sendToAdmin.stream().filter(addr -> !recipientsAddr.contains(addr) && !recipientsCCAddr.contains(addr)).collect(Collectors.toUnmodifiableList());
            SendMailDto sendMailDto = new SendMailDto(templateName, Optional.ofNullable(mailConf.getLang()).orElse(Locale.getDefault()), templateVars, senderAddr, recipientsAddr, recipientsCCAddr, recipientsBCCAddr);
            sendMailDto.setReplyToAddr(this.optional(mailConf.getReplyTo(), RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getReplyTo(), senderAddr));
            sendMailDto.setExternalReference("jobkit:" + this.runnerConf.getName());
            sendMailDto.setSenderReference(RegularProcessRunnerServiceImpl.this.regularProcessRunnersConfigurer.getSenderReference());
            sendMailDto.setGrade(SendMailDto.MessageGrade.EVENT_NOTICE);
            RegularProcessRunnerServiceImpl.this.sendMailService.sendEmail(sendMailDto);
        }

        private String optional(String ... values) {
            if (values == null || values.length == 0) {
                return null;
            }
            return Arrays.stream(values).filter(Objects::nonNull).map(String::trim).filter(v -> !v.isEmpty()).findFirst().orElse(null);
        }

        Map<String, String> getEnv() {
            return this.env;
        }

        Exec getExec() {
            return this.exec;
        }

        RegularProcessRunnersConfigurer.RegularProcessRunnerEntry getRunnerConf() {
            return this.runnerConf;
        }

        public class ProcessExecutionException
        extends RuntimeException {
            private ProcessExecutionException(Throwable cause) {
                super(Task.this.execName + " " + Task.this.exec.getParameters().toString(), cause);
            }
        }
    }
}

