/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFileInMemoryDb;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.WatchedFilesDb;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class WatchedFilesInMemoryDb
implements WatchedFilesDb {
    private static final Logger log = LogManager.getLogger();
    private final Map<CachedFileAttributes, WatchedFileInMemoryDb> allWatchedFiles = new HashMap<CachedFileAttributes, WatchedFileInMemoryDb>();
    private int maxDeep = 10;
    private ObservedFolder observedFolder;
    private WatchFolderPickupType pickUp;
    private Duration minFixedStateTime;

    public int getMaxDeep() {
        return this.maxDeep;
    }

    public void setMaxDeep(int maxDeep) {
        this.maxDeep = maxDeep;
    }

    @Override
    public void setup(ObservedFolder observedFolder, WatchFolderPickupType pickUp) {
        this.observedFolder = observedFolder;
        observedFolder.postConfiguration();
        this.pickUp = pickUp;
        this.minFixedStateTime = observedFolder.getMinFixedStateTime();
        try {
            AbstractFileSystemURL fs = observedFolder.createFileSystem();
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException("Can't load FileSystem", e));
        }
        if (!observedFolder.isRecursive()) {
            this.maxDeep = 0;
        }
        log.debug("Setup WFDB for {}, pickUp: {}, minFixedStateTime: {}, maxDeep: {}", (Object)observedFolder.getLabel(), (Object)pickUp, (Object)this.minFixedStateTime, (Object)this.maxDeep);
    }

    @Override
    public void reset(Set<CachedFileAttributes> foundedFiles) {
        foundedFiles.forEach(this.allWatchedFiles::remove);
    }

    @Override
    public WatchedFiles update(AbstractFileSystemURL fileSystem) {
        HashSet<CachedFileAttributes> detected = new HashSet<CachedFileAttributes>();
        this.actualScan(fileSystem.getRootPath(), this.maxDeep, detected);
        List updateFounded = detected.stream().filter(this.allWatchedFiles::containsKey).map(f -> this.allWatchedFiles.get(f).update((CachedFileAttributes)f)).collect(Collectors.toUnmodifiableList());
        log.trace("List updateFounded={}", updateFounded);
        List qualifyFounded = updateFounded.stream().filter(WatchedFileInMemoryDb::isNotYetMarkedAsDone).filter(WatchedFileInMemoryDb::isQualified).map(WatchedFileInMemoryDb::setMarkedAsDone).collect(Collectors.toUnmodifiableList());
        log.trace("List qualifyFounded={}", qualifyFounded);
        Set<CachedFileAttributes> qualifiedAndCallbacked = qualifyFounded.stream().filter(WatchedFileInMemoryDb::canBeCallbacked).map(WatchedFileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        log.trace("List qualifiedAndCallbacked={}", qualifiedAndCallbacked);
        List losted = this.allWatchedFiles.values().stream().filter(WatchedFileInMemoryDb::isNotYetMarkedAsDone).filter(w -> w.absentInSet(detected)).collect(Collectors.toUnmodifiableList());
        Set<CachedFileAttributes> lostedAndCallbacked = losted.stream().filter(WatchedFileInMemoryDb::canBePickup).map(WatchedFileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        detected.stream().filter(Predicate.not(this.allWatchedFiles::containsKey)).forEach(f -> this.allWatchedFiles.put((CachedFileAttributes)f, new WatchedFileInMemoryDb((CachedFileAttributes)f, this.pickUp, this.minFixedStateTime)));
        this.allWatchedFiles.keySet().stream().filter(Predicate.not(detected::contains)).collect(Collectors.toUnmodifiableList()).forEach(this.allWatchedFiles::remove);
        int size = this.pickUp == WatchFolderPickupType.FILES_DIRS ? this.allWatchedFiles.size() : (int)this.allWatchedFiles.values().stream().filter(WatchedFileInMemoryDb::canBePickup).count();
        log.debug("Scan result for {}: {} founded, {} lost, {} total", (Object)this.observedFolder.getLabel(), (Object)qualifiedAndCallbacked.size(), (Object)lostedAndCallbacked.size(), (Object)size);
        return new WatchedFiles(qualifiedAndCallbacked, lostedAndCallbacked, size);
    }

    private void actualScan(AbstractFile aSource, int deep, Set<CachedFileAttributes> detected) {
        Set<String> ignoreFiles = this.observedFolder.getIgnoreFiles();
        boolean allowedHidden = this.observedFolder.isAllowedHidden();
        boolean allowedLinks = this.observedFolder.isAllowedLinks();
        Set<String> allowedExtentions = this.observedFolder.getAllowedExtentions();
        Set<String> blockedExtentions = this.observedFolder.getBlockedExtentions();
        Set<String> ignoreRelativePaths = this.observedFolder.getIgnoreRelativePaths();
        List result = aSource.toCachedList().peek(f -> log.trace("Detect file={}", f)).filter(f -> !ignoreFiles.contains(f.getName().toLowerCase())).filter(f -> !(!allowedHidden && (f.isHidden() || f.getName().startsWith(".")))).filter(f -> !(!allowedLinks && f.isLink())).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            if (!allowedExtentions.isEmpty()) {
                return allowedExtentions.contains(FilenameUtils.getExtension((String)f.getName()).toLowerCase());
            }
            return true;
        }).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            return !blockedExtentions.contains(FilenameUtils.getExtension((String)f.getName()).toLowerCase());
        }).filter(f -> {
            if (ignoreRelativePaths.isEmpty()) {
                return true;
            }
            return !ignoreRelativePaths.contains(f.getPath());
        }).filter(f -> f.isDirectory() || !f.isSpecial()).collect(Collectors.toUnmodifiableList());
        detected.addAll(result);
        log.debug(() -> "Scanned files/dirs for \"" + aSource.getPath() + "\" (deep " + deep + "): " + result.stream().map(CachedFileAttributes::getName).sorted().collect(Collectors.joining(", ")) + " on \"" + aSource.getFileSystem().toString() + "\"");
        if (deep > 0) {
            result.stream().filter(CachedFileAttributes::isDirectory).forEach(f -> this.actualScan(f.getAbstractFile(), deep - 1, detected));
        }
    }
}

