/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;

public class ObservedFolder {
    private String targetFolder;
    private String label;
    private Set<String> allowedExtentions;
    private Set<String> blockedExtentions;
    private Set<String> ignoreRelativePaths;
    private Set<String> ignoreFiles;
    private boolean allowedHidden;
    private boolean allowedLinks;
    private boolean recursive;
    private Duration minFixedStateTime;
    private static final UnaryOperator<String> removeFirstDot = ext -> {
        if (ext.startsWith(".")) {
            return ext.substring(1);
        }
        return ext;
    };

    void postConfiguration() {
        Objects.requireNonNull(this.targetFolder, "Null targetFolder");
        try {
            AbstractFileSystemURL checkParse;
            File targetFolderF = new File(this.targetFolder);
            if (targetFolderF.exists()) {
                String newTargetFolder = "file://localhost" + AbstractFile.normalizePath((String)targetFolderF.getCanonicalFile().getAbsolutePath());
                checkParse = new AbstractFileSystemURL(newTargetFolder);
                this.targetFolder = newTargetFolder;
            } else {
                checkParse = new AbstractFileSystemURL(this.targetFolder);
            }
            checkParse.close();
            if (this.label == null || this.label.isEmpty()) {
                this.label = checkParse.toString();
            }
        }
        catch (IOException e1) {
            throw new UncheckedIOException(new IOException("Can't load: \"" + this.targetFolder + "\""));
        }
        this.allowedExtentions = Optional.ofNullable(this.allowedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.blockedExtentions = Optional.ofNullable(this.blockedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreRelativePaths = Optional.ofNullable(this.ignoreRelativePaths).orElse(Set.of()).stream().map(path -> path.replace('\\', '/')).map(AbstractFile::normalizePath).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreFiles = Optional.ofNullable(this.ignoreFiles).orElse(Set.of()).stream().map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.minFixedStateTime = Optional.ofNullable(this.minFixedStateTime).orElse(Duration.ZERO);
    }

    public String toString() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public AbstractFileSystemURL createFileSystem() {
        return new AbstractFileSystemURL(this.targetFolder);
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public Set<String> getAllowedExtentions() {
        return this.allowedExtentions;
    }

    public void setAllowedExtentions(Set<String> allowedExtentions) {
        this.allowedExtentions = allowedExtentions;
    }

    public Set<String> getBlockedExtentions() {
        return this.blockedExtentions;
    }

    public void setBlockedExtentions(Set<String> blockedExtentions) {
        this.blockedExtentions = blockedExtentions;
    }

    public Set<String> getIgnoreRelativePaths() {
        return this.ignoreRelativePaths;
    }

    public void setIgnoreRelativePaths(Set<String> ignoreRelativePaths) {
        this.ignoreRelativePaths = ignoreRelativePaths;
    }

    public boolean isAllowedHidden() {
        return this.allowedHidden;
    }

    public void setAllowedHidden(boolean allowedHidden) {
        this.allowedHidden = allowedHidden;
    }

    public boolean isAllowedLinks() {
        return this.allowedLinks;
    }

    public void setAllowedLinks(boolean allowedLinks) {
        this.allowedLinks = allowedLinks;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Set<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public void setIgnoreFiles(Set<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public Duration getMinFixedStateTime() {
        return this.minFixedStateTime;
    }

    public void setMinFixedStateTime(Duration minFixedStateTime) {
        this.minFixedStateTime = minFixedStateTime;
    }
}

