/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.jobkit.engine.BackgroundService;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.watchfolder.FolderActivity;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.RetryScanPolicyOnUserError;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.WatchedFilesDb;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class Watchfolders {
    private static final Logger log = LoggerFactory.getLogger(Watchfolders.class);
    static final int DEFAULT_RETRY_AFTER_TIME = 10;
    private final Map<ObservedFolder, BackgroundService> observedFoldersServices;
    private final FolderActivity folderActivity;
    private final Duration defaultTimeBetweenScans;
    private final JobKitEngine jobKitEngine;
    private final String defaultSpoolScans;
    private final String defaultSpoolEvents;

    public Watchfolders(Collection<? extends ObservedFolder> allObservedFolders, FolderActivity folderActivity, Duration defaultTimeBetweenScans, JobKitEngine jobKitEngine, String defaultSpoolScans, String defaultSpoolEvents, Supplier<WatchedFilesDb> watchedFilesDbBuilder) {
        this.folderActivity = Objects.requireNonNull(folderActivity);
        this.defaultTimeBetweenScans = Objects.requireNonNull(defaultTimeBetweenScans);
        this.jobKitEngine = Objects.requireNonNull(jobKitEngine);
        this.defaultSpoolScans = Objects.requireNonNull(defaultSpoolScans);
        this.defaultSpoolEvents = Objects.requireNonNull(defaultSpoolEvents);
        Objects.requireNonNull(watchedFilesDbBuilder);
        int allLabelsCount = (int)allObservedFolders.stream().map(ObservedFolder::getLabel).distinct().count();
        if (allObservedFolders.size() != allLabelsCount) {
            throw new IllegalArgumentException("ObservedFolders setup fail: you must have separate labels name for each entry");
        }
        this.observedFoldersServices = Objects.requireNonNull(allObservedFolders).stream().filter(Predicate.not(ObservedFolder::isDisabled)).collect(Collectors.toUnmodifiableMap(of -> of, oF -> this.createService((ObservedFolder)oF, (WatchedFilesDb)watchedFilesDbBuilder.get())));
        if (this.observedFoldersServices.isEmpty()) {
            log.warn("No configured watchfolders");
        }
    }

    Map<ObservedFolder, BackgroundService> getObservedFoldersServices() {
        return this.observedFoldersServices;
    }

    private void justLogAfterBadUserRun(Exception e) {
        if (e != null) {
            log.error("Can't send event", (Throwable)e);
        }
    }

    BackgroundService createService(ObservedFolder observedFolder, WatchedFilesDb db) {
        String name = observedFolder.getLabel();
        if (observedFolder.getSpoolEvents() == null || observedFolder.getSpoolEvents().equals("")) {
            observedFolder.setSpoolEvents(this.defaultSpoolEvents);
        }
        if (observedFolder.getSpoolScans() == null || observedFolder.getSpoolScans().equals("")) {
            observedFolder.setSpoolScans(this.defaultSpoolScans);
        }
        if (observedFolder.getTimeBetweenScans() == null || observedFolder.getTimeBetweenScans().equals(Duration.ZERO)) {
            observedFolder.setTimeBetweenScans(this.defaultTimeBetweenScans);
        }
        if (observedFolder.getRetryAfterTimeFactor() < 1) {
            observedFolder.setRetryAfterTimeFactor(10);
        }
        WatchFolderPickupType pickUp = this.folderActivity.getPickUpType(observedFolder);
        db.setup(observedFolder, Optional.ofNullable(pickUp).orElse(WatchFolderPickupType.FILES_ONLY));
        return this.jobKitEngine.createService("Watchfolder for " + name, observedFolder.getSpoolScans(), () -> {
            try (AbstractFileSystemURL fs = observedFolder.createFileSystem();){
                log.trace("Start Watchfolder scan for {} :: {}", (Object)name, (Object)fs);
                this.jobKitEngine.runOneShot("Watchfolder start dir scan for " + name, observedFolder.getSpoolEvents(), observedFolder.getJobsPriority(), () -> this.folderActivity.onBeforeScan(observedFolder), this::justLogAfterBadUserRun);
                long startTime = System.currentTimeMillis();
                WatchedFiles scanResult = db.update(observedFolder, fs);
                Duration scanTime = Duration.of(System.currentTimeMillis() - startTime, ChronoUnit.MILLIS);
                this.jobKitEngine.runOneShot("On event on watchfolder scan for " + name, observedFolder.getSpoolEvents(), observedFolder.getJobsPriority(), () -> this.folderActivity.onAfterScan(observedFolder, scanTime, scanResult), e -> {
                    if (e == null) {
                        return;
                    }
                    RetryScanPolicyOnUserError policy = this.folderActivity.retryScanPolicyOnUserError(observedFolder, scanResult, (Exception)e);
                    Set<CachedFileAttributes> founded = scanResult.founded();
                    if (!founded.isEmpty()) {
                        log.error("Can't process user event of onAfterScan ({} founded), policy is {}", new Object[]{founded.size(), policy, e});
                        if (policy == RetryScanPolicyOnUserError.RETRY_FOUNDED_FILE) {
                            db.reset(observedFolder, founded);
                        }
                    } else {
                        log.error("Can't process user event of onAfterScan", (Throwable)e);
                    }
                });
                log.trace("Ends Watchfolder scan for {} :: {}", (Object)name, (Object)fs);
            }
            catch (Exception e2) {
                this.folderActivity.onScanErrorFolder(observedFolder, e2);
                throw e2;
            }
        }, () -> this.folderActivity.onStopScan(observedFolder)).setTimedInterval(observedFolder.getTimeBetweenScans()).setRetryAfterTimeFactor((double)observedFolder.getRetryAfterTimeFactor()).setPriority(observedFolder.getJobsPriority());
    }

    public synchronized void startScans() {
        this.observedFoldersServices.forEach((oF, service) -> {
            if (service.isEnabled()) {
                return;
            }
            this.jobKitEngine.runOneShot("Start (enable) watchfolder scans for " + oF.getLabel(), oF.getSpoolEvents(), oF.getJobsPriority(), () -> {
                this.folderActivity.onStartScan((ObservedFolder)oF);
                service.enable();
            }, this::justLogAfterBadUserRun);
        });
    }

    public synchronized void stopScans() {
        this.observedFoldersServices.values().stream().forEach(BackgroundService::disable);
    }
}

