/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.jobkit.watchfolder.FileInMemoryDb;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFileScanner;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.WatchedFilesDb;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class WatchedFilesInMemoryDb
implements WatchedFilesDb {
    private static final Logger log = LoggerFactory.getLogger(WatchedFilesInMemoryDb.class);
    private final Map<CachedFileAttributes, FileInMemoryDb> allWatchedFiles;
    private final int defaultMaxDeep;
    private WatchFolderPickupType pickUp;
    private Duration minFixedStateTime;
    private WatchedFileScanner scanner;

    public WatchedFilesInMemoryDb(int defaultMaxDeep) {
        this.defaultMaxDeep = defaultMaxDeep;
        this.allWatchedFiles = new HashMap<CachedFileAttributes, FileInMemoryDb>();
    }

    public WatchedFilesInMemoryDb() {
        this(10);
    }

    @Override
    public void setup(ObservedFolder observedFolder, WatchFolderPickupType pickUp) {
        if (observedFolder.isDisabled()) {
            throw new IllegalArgumentException("Can't setup a disabled observedFolder: " + observedFolder);
        }
        this.scanner = new WatchedFileScanner(observedFolder, this.defaultMaxDeep);
        this.pickUp = pickUp;
        this.minFixedStateTime = observedFolder.getMinFixedStateTime();
    }

    @Override
    public void reset(ObservedFolder observedFolder, Set<CachedFileAttributes> foundedFiles) {
        foundedFiles.forEach(this.allWatchedFiles::remove);
    }

    @Override
    public WatchedFiles update(ObservedFolder observedFolder, AbstractFileSystemURL fileSystem) {
        List<CachedFileAttributes> detected = this.scanner.scan(fileSystem);
        List<FileInMemoryDb> updateFounded = detected.stream().filter(this.allWatchedFiles::containsKey).map(f -> this.allWatchedFiles.get(f).update((CachedFileAttributes)f)).toList();
        Set<CachedFileAttributes> updatedChangedFounded = updateFounded.stream().filter(Predicate.not(FileInMemoryDb::isNotYetMarkedAsDone)).filter(FileInMemoryDb::canBeCallbacked).filter(FileInMemoryDb::isDoneButChanged).map(FileInMemoryDb::resetDoneButChanged).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        List<FileInMemoryDb> qualifyFounded = updateFounded.stream().filter(FileInMemoryDb::isNotYetMarkedAsDone).filter(FileInMemoryDb::isTimeQualified).map(FileInMemoryDb::setMarkedAsDone).toList();
        Set<CachedFileAttributes> qualifiedAndCallbacked = qualifyFounded.stream().filter(FileInMemoryDb::canBeCallbacked).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        List<FileInMemoryDb> losted = this.allWatchedFiles.values().stream().filter(FileInMemoryDb::isNotYetMarkedAsDone).filter(w -> w.absentInSet(detected)).toList();
        Set lostedAndCallbacked = losted.stream().filter(FileInMemoryDb::canBePickupFromType).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        detected.stream().filter(Predicate.not(this.allWatchedFiles::containsKey)).peek(f -> log.trace("Add to Db: {} ({})", f, (Object)f.hashCode())).forEach(f -> this.allWatchedFiles.put((CachedFileAttributes)f, new FileInMemoryDb((CachedFileAttributes)f, this.pickUp, this.minFixedStateTime)));
        List<CachedFileAttributes> toClean = this.allWatchedFiles.keySet().stream().filter(Predicate.not(detected::contains)).toList();
        toClean.forEach(this.allWatchedFiles::remove);
        log.trace("Lists detected={}, updateFounded={}, updatedChangedFounded={}, qualifyFounded={}, qualifiedAndCallbacked={}, losted={}, lostedAndCallbacked={}, toClean={}", new Object[]{detected, updateFounded, updatedChangedFounded, qualifyFounded, qualifiedAndCallbacked, losted, lostedAndCallbacked, toClean});
        int size = this.pickUp == WatchFolderPickupType.FILES_DIRS ? this.allWatchedFiles.size() : (int)this.allWatchedFiles.values().stream().filter(FileInMemoryDb::canBePickupFromType).count();
        log.debug("Scan result for {}: {} founded, {} lost, {} total", new Object[]{observedFolder.getLabel(), qualifiedAndCallbacked.size(), lostedAndCallbacked.size(), size});
        return new WatchedFiles(qualifiedAndCallbacked, lostedAndCallbacked, updatedChangedFounded, size);
    }
}

