/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.time.Duration;
import tv.hd3g.jobkit.engine.Supervisable;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.RetryScanPolicyOnUserError;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;

public interface FolderActivity {
    public static final String OBSERVEDFOLDER = "ObservedFolder";

    public void onAfterScan(ObservedFolder var1, Duration var2, WatchedFiles var3) throws IOException;

    default public void onStartScan(ObservedFolder observedFolder) throws IOException {
        Supervisable.getSupervisable().setContext(OBSERVEDFOLDER, (Object)observedFolder).markAsInternalStateChange().resultDone("startscan", "Start scans", new Object[0]);
    }

    default public void onStopScan(ObservedFolder observedFolder) throws IOException {
        Supervisable.getSupervisable().setContext(OBSERVEDFOLDER, (Object)observedFolder).markAsInternalStateChange().resultDone("stopscan", "Stop scans", new Object[0]);
    }

    default public void onBeforeScan(ObservedFolder observedFolder) throws IOException {
    }

    default public WatchFolderPickupType getPickUpType(ObservedFolder observedFolder) {
        return WatchFolderPickupType.FILES_ONLY;
    }

    default public void onScanErrorFolder(ObservedFolder observedFolder, Exception e) throws IOException {
        Supervisable.getSupervisable().setContext(OBSERVEDFOLDER, (Object)observedFolder).markAsInternalStateChange().resultError(e);
    }

    default public RetryScanPolicyOnUserError retryScanPolicyOnUserError(ObservedFolder observedFolder, WatchedFiles scanResult, Exception e) {
        return RetryScanPolicyOnUserError.RETRY_FOUNDED_FILE;
    }

    public static boolean isFolderActivityEvent(SupervisableEndEvent event) {
        return event.isInternalStateChangeMarked() && OBSERVEDFOLDER.equalsIgnoreCase(event.typeName());
    }
}

