/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.transfertfiles.CachedFileAttributes;

class FileInMemoryDb {
    private static final Logger log = LoggerFactory.getLogger(FileInMemoryDb.class);
    private final boolean isDirectory;
    private final boolean pickUpFiles;
    private final boolean pickUpDirs;
    private final Duration minFixedStateTime;
    private CachedFileAttributes lastFile;
    private long lastWatched;
    private boolean markedAsDone;
    private boolean lastIsSame;
    private boolean doneButChanged;

    FileInMemoryDb(CachedFileAttributes firstDetectionFile, WatchFolderPickupType pickUp, Duration minFixedStateTime) {
        this.lastFile = firstDetectionFile;
        this.isDirectory = firstDetectionFile.isDirectory();
        this.lastWatched = System.currentTimeMillis();
        this.lastIsSame = false;
        this.doneButChanged = false;
        this.pickUpFiles = pickUp.isPickUpFiles();
        this.pickUpDirs = pickUp.isPickUpDirs();
        this.minFixedStateTime = minFixedStateTime;
        log.trace("Create FileInMemoryDb for {}, {} ({})", new Object[]{firstDetectionFile, pickUp, minFixedStateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lastFile);
        sb.append("{since ");
        sb.append(System.currentTimeMillis() - this.lastWatched);
        sb.append("ms ");
        if (this.markedAsDone) {
            sb.append("markedAsDone ");
        }
        if (this.doneButChanged) {
            sb.append("doneButChanged");
        }
        if (this.lastIsSame) {
            sb.append("lastIsSame ");
        }
        return sb.toString().trim() + "}";
    }

    FileInMemoryDb update(CachedFileAttributes seeAgainFile) {
        if (this.isDirectory) {
            if (!this.markedAsDone) {
                this.lastFile = seeAgainFile;
            }
        } else {
            boolean bl = this.lastIsSame = this.lastFile.lastModified() == seeAgainFile.lastModified() && this.lastFile.length() == seeAgainFile.length();
            if (!this.lastIsSame) {
                this.lastWatched = System.currentTimeMillis();
                if (this.markedAsDone) {
                    this.doneButChanged = true;
                }
            }
            this.lastFile = seeAgainFile;
        }
        return this;
    }

    boolean isTimeQualified() {
        boolean notTooRecent = this.lastWatched < System.currentTimeMillis() - this.minFixedStateTime.toMillis();
        return this.isDirectory || this.lastIsSame && notTooRecent;
    }

    boolean canBeCallbacked() {
        return this.isTimeQualified() && this.canBePickupFromType();
    }

    boolean canBePickupFromType() {
        return this.isDirectory && this.pickUpDirs || !this.isDirectory && this.pickUpFiles;
    }

    FileInMemoryDb setMarkedAsDone() {
        this.markedAsDone = true;
        return this;
    }

    boolean isNotYetMarkedAsDone() {
        return !this.markedAsDone;
    }

    boolean isDoneButChanged() {
        return this.doneButChanged;
    }

    FileInMemoryDb resetDoneButChanged() {
        this.doneButChanged = false;
        return this;
    }

    CachedFileAttributes getLastFile() {
        return this.lastFile;
    }

    boolean absentInSet(Collection<CachedFileAttributes> detected) {
        return !detected.contains(this.lastFile);
    }
}

