/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.InvalidURLException;
import tv.hd3g.transfertfiles.URLAccess;

public class ObservedFolder {
    private static final Logger log = LogManager.getLogger();
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String targetFolder;
    private String label;
    private Set<String> allowedExtentions;
    private Set<String> blockedExtentions;
    private Set<String> ignoreRelativePaths;
    private Set<String> ignoreFiles;
    private Set<String> allowedFileNames;
    private Set<String> allowedDirNames;
    private Set<String> blockedFileNames;
    private Set<String> blockedDirNames;
    private boolean allowedHidden;
    private boolean allowedLinks;
    private boolean recursive;
    private Duration minFixedStateTime;
    private boolean disabled;
    private static final UnaryOperator<String> removeFirstDot = ext -> {
        if (ext.startsWith(".")) {
            return ext.substring(1);
        }
        return ext;
    };

    private static AbstractFileSystemURL initURL(String url) throws IOException {
        try (AbstractFileSystemURL fs = new AbstractFileSystemURL(url);){
            AbstractFileSystemURL abstractFileSystemURL = fs;
            return abstractFileSystemURL;
        }
    }

    private static AbstractFileSystemURL checkURL(String url) throws IOException {
        try {
            new URLAccess(url);
        }
        catch (Exception e) {
            throw new InvalidURLException("Can't found directory, or it doesn't seem to be an valid URL", (Object)url);
        }
        AbstractFileSystemURL checkParse = ObservedFolder.initURL(url);
        return checkParse;
    }

    void postConfiguration() {
        if (this.disabled) {
            return;
        }
        this.allowedExtentions = Optional.ofNullable(this.allowedExtentions).orElse(Set.of());
        this.blockedExtentions = Optional.ofNullable(this.blockedExtentions).orElse(Set.of());
        this.ignoreRelativePaths = Optional.ofNullable(this.ignoreRelativePaths).orElse(Set.of());
        this.ignoreFiles = Optional.ofNullable(this.ignoreFiles).orElse(Set.of());
        this.minFixedStateTime = Optional.ofNullable(this.minFixedStateTime).orElse(Duration.ZERO);
        this.allowedFileNames = Optional.ofNullable(this.allowedFileNames).orElse(Set.of());
        this.allowedDirNames = Optional.ofNullable(this.allowedDirNames).orElse(Set.of());
        this.blockedFileNames = Optional.ofNullable(this.blockedFileNames).orElse(Set.of());
        this.blockedDirNames = Optional.ofNullable(this.blockedDirNames).orElse(Set.of());
        this.internalPostConfiguration();
        Objects.requireNonNull(this.targetFolder, "Null targetFolder");
        try {
            AbstractFileSystemURL checkParse;
            File targetFolderF = new File(this.targetFolder);
            if (targetFolderF.exists()) {
                String newTargetFolder = "file://localhost" + AbstractFile.normalizePath((String)targetFolderF.getCanonicalFile().getAbsolutePath());
                checkParse = ObservedFolder.initURL(newTargetFolder);
                this.targetFolder = newTargetFolder;
            } else {
                checkParse = ObservedFolder.checkURL(this.targetFolder);
            }
            if (this.label == null || this.label.isEmpty()) {
                this.label = checkParse.toString();
                log.warn("You should setup a label for {}", (Object)this.label);
            }
        }
        catch (IOException e1) {
            throw new UncheckedIOException(new IOException("Can't load: \"" + this.targetFolder + "\""));
        }
        this.allowedExtentions = Optional.ofNullable(this.allowedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.blockedExtentions = Optional.ofNullable(this.blockedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreRelativePaths = Optional.ofNullable(this.ignoreRelativePaths).orElse(Set.of()).stream().map(path -> path.replace('\\', '/')).map(AbstractFile::normalizePath).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreFiles = Optional.ofNullable(this.ignoreFiles).orElse(Set.of()).stream().map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.minFixedStateTime = Optional.ofNullable(this.minFixedStateTime).orElse(Duration.ZERO);
        this.allowedFileNames = Optional.ofNullable(this.allowedFileNames).orElse(Set.of()).stream().collect(Collectors.toUnmodifiableSet());
        this.allowedDirNames = Optional.ofNullable(this.allowedDirNames).orElse(Set.of()).stream().collect(Collectors.toUnmodifiableSet());
        this.blockedFileNames = Optional.ofNullable(this.blockedFileNames).orElse(Set.of()).stream().collect(Collectors.toUnmodifiableSet());
        this.blockedDirNames = Optional.ofNullable(this.blockedDirNames).orElse(Set.of()).stream().collect(Collectors.toUnmodifiableSet());
    }

    protected void internalPostConfiguration() {
    }

    public String toString() {
        return this.label;
    }

    public AbstractFileSystemURL createFileSystem() {
        return new AbstractFileSystemURL(this.targetFolder);
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getAllowedExtentions() {
        return this.allowedExtentions;
    }

    public Set<String> getBlockedExtentions() {
        return this.blockedExtentions;
    }

    public Set<String> getIgnoreRelativePaths() {
        return this.ignoreRelativePaths;
    }

    public Set<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public Set<String> getAllowedFileNames() {
        return this.allowedFileNames;
    }

    public Set<String> getAllowedDirNames() {
        return this.allowedDirNames;
    }

    public Set<String> getBlockedFileNames() {
        return this.blockedFileNames;
    }

    public Set<String> getBlockedDirNames() {
        return this.blockedDirNames;
    }

    public boolean isAllowedHidden() {
        return this.allowedHidden;
    }

    public boolean isAllowedLinks() {
        return this.allowedLinks;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Duration getMinFixedStateTime() {
        return this.minFixedStateTime;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAllowedExtentions(Set<String> allowedExtentions) {
        this.allowedExtentions = allowedExtentions;
    }

    public void setBlockedExtentions(Set<String> blockedExtentions) {
        this.blockedExtentions = blockedExtentions;
    }

    public void setIgnoreRelativePaths(Set<String> ignoreRelativePaths) {
        this.ignoreRelativePaths = ignoreRelativePaths;
    }

    public void setIgnoreFiles(Set<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public void setAllowedFileNames(Set<String> allowedFileNames) {
        this.allowedFileNames = allowedFileNames;
    }

    public void setAllowedDirNames(Set<String> allowedDirNames) {
        this.allowedDirNames = allowedDirNames;
    }

    public void setBlockedFileNames(Set<String> blockedFileNames) {
        this.blockedFileNames = blockedFileNames;
    }

    public void setBlockedDirNames(Set<String> blockedDirNames) {
        this.blockedDirNames = blockedDirNames;
    }

    public void setAllowedHidden(boolean allowedHidden) {
        this.allowedHidden = allowedHidden;
    }

    public void setAllowedLinks(boolean allowedLinks) {
        this.allowedLinks = allowedLinks;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setMinFixedStateTime(Duration minFixedStateTime) {
        this.minFixedStateTime = minFixedStateTime;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObservedFolder)) {
            return false;
        }
        ObservedFolder other = (ObservedFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObservedFolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

