/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.FileAttributesReference;

public record WatchedFiles(Set<CachedFileAttributes> founded, Set<? extends FileAttributesReference> losted, Set<CachedFileAttributes> updated, int totalFiles) {
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WatchedFiles [founded=");
        builder.append(this.founded.stream().map(FileAttributesReference::getPath).collect(Collectors.joining(", ")));
        builder.append(", losted=");
        builder.append(this.losted.stream().map(FileAttributesReference::getPath).collect(Collectors.joining(", ")));
        builder.append(", updated=");
        builder.append(this.updated.stream().map(FileAttributesReference::getPath).collect(Collectors.joining(", ")));
        builder.append(", totalFiles=");
        builder.append(this.totalFiles);
        builder.append("]");
        return builder.toString();
    }

    @JsonIgnore
    public Set<CachedFileAttributes> foundedAndUpdated() {
        return Stream.concat(this.founded.stream(), this.updated.stream()).distinct().collect(Collectors.toUnmodifiableSet());
    }

    @JsonIgnore
    public Set<AbstractFileSystem<?>> getFoundedAndUpdatedFS() {
        return this.foundedAndUpdated().stream().map(CachedFileAttributes::getAbstractFile).map(AbstractFile::getFileSystem).distinct().collect(Collectors.toUnmodifiableSet());
    }
}

