/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.FileAttributesReference;

public class WatchedFileScanner {
    private static Logger log = LogManager.getLogger();
    private final int maxDeep;
    private final ObservedFolder observedFolder;
    private final Duration minFixedStateTime;

    public WatchedFileScanner(ObservedFolder observedFolder) {
        this(observedFolder, 10);
    }

    public WatchedFileScanner(ObservedFolder observedFolder, int maxDeep) {
        log.debug("Start internal Watchfolder configuration checks {}", (Object)observedFolder);
        this.observedFolder = Objects.requireNonNull(observedFolder);
        observedFolder.postConfiguration();
        this.maxDeep = observedFolder.isRecursive() ? maxDeep : 0;
        this.minFixedStateTime = observedFolder.getMinFixedStateTime();
        try {
            AbstractFileSystemURL fs = observedFolder.createFileSystem();
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException("Can't load FileSystem", e));
        }
        log.debug("Setup WFDB for {}, with minFixedStateTime={} and maxDeep={}", (Object)observedFolder, (Object)this.minFixedStateTime, (Object)maxDeep);
    }

    public List<CachedFileAttributes> scan(AbstractFileSystemURL fileSystem) {
        ArrayList<CachedFileAttributes> detected = new ArrayList<CachedFileAttributes>();
        log.debug("Start scan {} to {}", (Object)this.observedFolder, (Object)fileSystem);
        this.actualScan(fileSystem.getRootPath(), this.maxDeep, detected);
        return detected;
    }

    private void actualScan(AbstractFile aSource, int deep, Collection<CachedFileAttributes> detected) {
        Set<String> ignoreFiles = this.observedFolder.getIgnoreFiles();
        boolean allowedHidden = this.observedFolder.isAllowedHidden();
        boolean allowedLinks = this.observedFolder.isAllowedLinks();
        Set<String> allowedExtentions = this.observedFolder.getAllowedExtentions();
        Set<String> blockedExtentions = this.observedFolder.getBlockedExtentions();
        Set<String> ignoreRelativePaths = this.observedFolder.getIgnoreRelativePaths();
        List<CachedFileAttributes> result = aSource.toCachedList().peek(f -> log.trace("Detect file={}", f)).filter(f -> !ignoreFiles.contains(f.getName().toLowerCase())).filter(f -> !(!allowedHidden && (f.isHidden() || f.getName().startsWith(".")))).filter(f -> !(!allowedLinks && f.isLink())).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            if (!allowedExtentions.isEmpty()) {
                return WatchedFileScanner.containExtension(f.getName(), allowedExtentions);
            }
            return true;
        }).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            return !WatchedFileScanner.containExtension(f.getName(), blockedExtentions);
        }).filter(f -> {
            if (ignoreRelativePaths.isEmpty()) {
                return true;
            }
            return !ignoreRelativePaths.contains(f.getPath());
        }).filter(this::checkAllowedNotBlocked).filter(f -> f.isDirectory() || !f.isSpecial()).toList();
        detected.addAll(result);
        log.debug(() -> "Scanned files/dirs for \"" + aSource.getPath() + "\" (deep " + deep + "): " + result.stream().map(FileAttributesReference::getName).sorted().collect(Collectors.joining(", ")) + " on \"" + aSource.getFileSystem().toString() + "\"");
        if (deep > 0) {
            result.stream().filter(FileAttributesReference::isDirectory).forEach(f -> this.actualScan(f.getAbstractFile(), deep - 1, detected));
        }
    }

    private boolean checkAllowedNotBlocked(CachedFileAttributes detectedFile) {
        String name = detectedFile.getName();
        if (detectedFile.isDirectory()) {
            Set<String> allowedDirNames = this.observedFolder.getAllowedDirNames();
            if (!allowedDirNames.isEmpty()) {
                return allowedDirNames.stream().anyMatch(w -> FilenameUtils.wildcardMatch((String)name, (String)w));
            }
            Set<String> blockedDirNames = this.observedFolder.getBlockedDirNames();
            if (!blockedDirNames.isEmpty()) {
                return blockedDirNames.stream().noneMatch(w -> FilenameUtils.wildcardMatch((String)name, (String)w));
            }
        } else {
            Set<String> allowedFileNames = this.observedFolder.getAllowedFileNames();
            if (!allowedFileNames.isEmpty()) {
                return allowedFileNames.stream().anyMatch(w -> FilenameUtils.wildcardMatch((String)name, (String)w));
            }
            Set<String> blockedFileNames = this.observedFolder.getBlockedFileNames();
            if (!blockedFileNames.isEmpty()) {
                return blockedFileNames.stream().noneMatch(w -> FilenameUtils.wildcardMatch((String)name, (String)w));
            }
        }
        return true;
    }

    public static boolean containExtension(String baseFileName, Set<String> candidates) {
        return candidates.stream().anyMatch(c -> baseFileName.toLowerCase().endsWith("." + c));
    }

    public int getMaxDeep() {
        return this.maxDeep;
    }
}

