/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.jobkit.engine.BackgroundService;
import tv.hd3g.jobkit.engine.JobKitEngine;
import tv.hd3g.jobkit.watchfolder.FolderActivity;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.RetryScanPolicyOnUserError;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.WatchedFilesDb;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class Watchfolders {
    private static final Logger log = LogManager.getLogger();
    private final List<? extends ObservedFolder> observedFolders;
    private final FolderActivity eventActivity;
    private final Duration timeBetweenScans;
    private final JobKitEngine jobKitEngine;
    private final String spoolScans;
    private final String spoolEvents;
    private final Map<ObservedFolder, WatchedFilesDb> wfDBForFolder;
    private final Map<ObservedFolder, BackgroundService> onErrorObservedFolders;
    private BackgroundService service;
    final Consumer<Exception> justLogAfterBadUserRun = e -> {
        if (e != null) {
            log.error("Can't send event", (Throwable)e);
        }
    };

    public Watchfolders(List<? extends ObservedFolder> allObservedFolders, FolderActivity eventActivity, Duration timeBetweenScans, JobKitEngine jobKitEngine, String spoolScans, String spoolEvents, Supplier<WatchedFilesDb> watchedFilesDbBuilder) {
        this.observedFolders = Objects.requireNonNull(allObservedFolders).stream().filter(Predicate.not(ObservedFolder::isDisabled)).toList();
        this.eventActivity = Objects.requireNonNull(eventActivity);
        this.timeBetweenScans = Objects.requireNonNull(timeBetweenScans);
        this.jobKitEngine = Objects.requireNonNull(jobKitEngine);
        this.spoolScans = Objects.requireNonNull(spoolScans);
        this.spoolEvents = Objects.requireNonNull(spoolEvents);
        this.onErrorObservedFolders = new ConcurrentHashMap<ObservedFolder, BackgroundService>();
        Objects.requireNonNull(watchedFilesDbBuilder);
        if (this.observedFolders.isEmpty()) {
            log.warn("No configured watchfolders for {}/{}", (Object)spoolScans, (Object)spoolEvents);
        }
        this.wfDBForFolder = this.observedFolders.stream().collect(Collectors.toUnmodifiableMap(observedFolder -> observedFolder, observedFolder -> {
            WatchedFilesDb watchedFilesDb = (WatchedFilesDb)watchedFilesDbBuilder.get();
            WatchFolderPickupType pickUp = eventActivity.getPickUpType((ObservedFolder)observedFolder);
            watchedFilesDb.setup((ObservedFolder)observedFolder, Optional.ofNullable(pickUp).orElse(WatchFolderPickupType.FILES_ONLY));
            return watchedFilesDb;
        }));
    }

    private void internalScan(ObservedFolder folder) {
        try (AbstractFileSystemURL fs = folder.createFileSystem();){
            String label = folder.getLabel();
            log.trace("Start Watchfolder scan for {} :: {}", (Object)label, (Object)fs);
            this.jobKitEngine.runOneShot("Watchfolder start dir scan for " + label, this.spoolEvents, 0, () -> this.eventActivity.onBeforeScan(folder), this.justLogAfterBadUserRun);
            long startTime = System.currentTimeMillis();
            WatchedFiles scanResult = this.wfDBForFolder.get(folder).update(folder, fs);
            Duration scanTime = Duration.of(System.currentTimeMillis() - startTime, ChronoUnit.MILLIS);
            this.jobKitEngine.runOneShot("On event on watchfolder scan for " + this.getWFName(), this.spoolEvents, 0, () -> this.eventActivity.onAfterScan(folder, scanTime, scanResult), e -> {
                if (e == null) {
                    return;
                }
                RetryScanPolicyOnUserError policy = this.eventActivity.retryScanPolicyOnUserError(folder, scanResult, (Exception)e);
                Set<CachedFileAttributes> founded = scanResult.founded();
                if (!founded.isEmpty()) {
                    log.error("Can't process user event of onAfterScan ({} founded), policy is {}", (Object)founded.size(), (Object)policy, e);
                    if (policy == RetryScanPolicyOnUserError.RETRY_FOUNDED_FILE) {
                        this.wfDBForFolder.get(folder).reset(folder, founded);
                    }
                } else {
                    log.error("Can't process user event of onAfterScan", (Throwable)e);
                }
            });
            log.trace("Ends Watchfolder scan for {} :: {}", (Object)label, (Object)fs);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private String getWFName() {
        return this.observedFolders.stream().map(ObservedFolder::getLabel).collect(Collectors.joining(", "));
    }

    public synchronized void startScans() {
        if (this.service != null && this.service.isEnabled() || this.observedFolders.isEmpty()) {
            return;
        }
        this.service = this.jobKitEngine.createService("Watchfolder for " + this.getWFName(), this.spoolScans, () -> {
            log.trace("Start full Watchfolders scans for {}", (Object)this.getWFName());
            long startTime = System.currentTimeMillis();
            List<ObservedFolder> newInError = this.observedFolders.stream().filter(Predicate.not(this.onErrorObservedFolders::containsKey)).filter(oF -> {
                try {
                    this.internalScan((ObservedFolder)oF);
                    return false;
                }
                catch (UncheckedIOException e) {
                    log.error("Problem during scan with {}, cancel scans for it", (Object)oF.getLabel(), (Object)e);
                    this.jobKitEngine.runOneShot("Problem during scan with watchfolder " + oF.getLabel(), this.spoolEvents, 0, () -> this.eventActivity.onScanErrorFolder((ObservedFolder)oF, e), this.justLogAfterBadUserRun);
                    return true;
                }
            }).toList();
            log.trace("Ends full Watchfolders scans for {} ({} ms) - {} in error", (Object)this.getWFName(), (Object)(System.currentTimeMillis() - startTime), (Object)newInError.size());
            this.retryInError(newInError);
        }, () -> this.eventActivity.onStopScans(this.observedFolders));
        this.service.setTimedInterval(this.timeBetweenScans);
        this.service.setRetryAfterTimeFactor(10.0);
        this.service.setPriority(0);
        this.jobKitEngine.runOneShot("Start (enable) watchfolder scans for " + this.getWFName(), this.spoolEvents, 0, () -> {
            this.eventActivity.onStartScans(this.observedFolders);
            this.service.enable();
        }, this.justLogAfterBadUserRun);
    }

    public synchronized BackgroundService getService() {
        return this.service;
    }

    public synchronized void stopScans() {
        if (this.service == null || !this.service.isEnabled()) {
            return;
        }
        this.service.disable();
        this.service = null;
    }

    private BackgroundService retryInError(ObservedFolder newInError) {
        return this.jobKitEngine.createService("Retry for watchfolder in error " + this.getWFName() + " > " + newInError.getLabel(), this.spoolScans, () -> {
            String label = newInError.getLabel();
            log.info("Retry to establish a connection to {}...", (Object)label);
            try (AbstractFileSystemURL fs = newInError.createFileSystem();){
                fs.getRootPath().toCachedList().count();
            }
            log.info("Connection is ok. Back to normal for {}", (Object)label);
            Optional.ofNullable(this.onErrorObservedFolders.remove(newInError)).ifPresent(BackgroundService::disable);
        }, () -> this.eventActivity.onStopScans(this.observedFolders));
    }

    private void retryInError(List<? extends ObservedFolder> newInError) {
        newInError.forEach(oF -> {
            BackgroundService serviceRetry = this.retryInError((ObservedFolder)oF);
            serviceRetry.setTimedInterval(this.timeBetweenScans);
            serviceRetry.setRetryAfterTimeFactor(10.0);
            serviceRetry.setPriority(this.service.getPriority() - 1);
            this.onErrorObservedFolders.put((ObservedFolder)oF, serviceRetry);
            serviceRetry.enable();
        });
    }
}

