/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import tv.hd3g.jobkit.engine.Supervisable;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.RetryScanPolicyOnUserError;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;

public interface FolderActivity {
    public void onAfterScan(ObservedFolder var1, Duration var2, WatchedFiles var3) throws IOException;

    default public void onStartScans(List<? extends ObservedFolder> observedFolders) throws IOException {
        Supervisable.getSupervisable().setContext("ObservedFolders", observedFolders).markAsInternalStateChange().resultDone("startscans", "Start scans", new Object[0]);
    }

    default public void onStopScans(List<? extends ObservedFolder> observedFolders) throws IOException {
        Supervisable.getSupervisable().setContext("ObservedFolders", observedFolders).markAsInternalStateChange().resultDone("stopscans", "Stop scans", new Object[0]);
    }

    default public void onBeforeScan(ObservedFolder observedFolder) throws IOException {
    }

    default public WatchFolderPickupType getPickUpType(ObservedFolder observedFolder) {
        return WatchFolderPickupType.FILES_ONLY;
    }

    default public void onScanErrorFolder(ObservedFolder observedFolder, Exception e) throws IOException {
        Supervisable.getSupervisable().setContext("ObservedFolder", (Object)observedFolder).markAsInternalStateChange().resultError(e);
    }

    default public RetryScanPolicyOnUserError retryScanPolicyOnUserError(ObservedFolder observedFolder, WatchedFiles scanResult, Exception e) {
        return RetryScanPolicyOnUserError.RETRY_FOUNDED_FILE;
    }

    public static boolean isFolderActivityEvent(SupervisableEndEvent event) {
        return event.isInternalStateChangeMarked() && ("ObservedFolder".equalsIgnoreCase(event.typeName()) || "ObservedFolders".equalsIgnoreCase(event.typeName()));
    }
}

