/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.jobkit.watchfolder.FileInMemoryDb;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.WatchedFilesDb;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class WatchedFilesInMemoryDb
implements WatchedFilesDb {
    private static final Logger log = LogManager.getLogger();
    private final Map<CachedFileAttributes, FileInMemoryDb> allWatchedFiles = new HashMap<CachedFileAttributes, FileInMemoryDb>();
    private int maxDeep = 10;
    private ObservedFolder observedFolder;
    private WatchFolderPickupType pickUp;
    private Duration minFixedStateTime;

    public int getMaxDeep() {
        return this.maxDeep;
    }

    public void setMaxDeep(int maxDeep) {
        this.maxDeep = maxDeep;
    }

    @Override
    public void setup(ObservedFolder observedFolder, WatchFolderPickupType pickUp) {
        this.observedFolder = observedFolder;
        observedFolder.postConfiguration();
        this.pickUp = pickUp;
        this.minFixedStateTime = observedFolder.getMinFixedStateTime();
        try {
            AbstractFileSystemURL fs = observedFolder.createFileSystem();
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException("Can't load FileSystem", e));
        }
        if (!observedFolder.isRecursive()) {
            this.maxDeep = 0;
        }
        log.debug("Setup WFDB for {}, pickUp: {}, minFixedStateTime: {}, maxDeep: {}", (Object)observedFolder.getLabel(), (Object)pickUp, (Object)this.minFixedStateTime, (Object)this.maxDeep);
    }

    @Override
    public void reset(Set<CachedFileAttributes> foundedFiles) {
        foundedFiles.forEach(this.allWatchedFiles::remove);
    }

    @Override
    public WatchedFiles update(AbstractFileSystemURL fileSystem) {
        HashSet<CachedFileAttributes> detected = new HashSet<CachedFileAttributes>();
        this.actualScan(fileSystem.getRootPath(), this.maxDeep, detected);
        List<FileInMemoryDb> updateFounded = detected.stream().filter(this.allWatchedFiles::containsKey).map(f -> this.allWatchedFiles.get(f).update((CachedFileAttributes)f)).toList();
        Set<CachedFileAttributes> updatedChangedFounded = updateFounded.stream().filter(Predicate.not(FileInMemoryDb::isNotYetMarkedAsDone)).filter(FileInMemoryDb::canBeCallbacked).filter(FileInMemoryDb::isDoneButChanged).map(FileInMemoryDb::resetDoneButChanged).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        List<FileInMemoryDb> qualifyFounded = updateFounded.stream().filter(FileInMemoryDb::isNotYetMarkedAsDone).filter(FileInMemoryDb::isTimeQualified).map(FileInMemoryDb::setMarkedAsDone).toList();
        Set<CachedFileAttributes> qualifiedAndCallbacked = qualifyFounded.stream().filter(FileInMemoryDb::canBeCallbacked).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        List<FileInMemoryDb> losted = this.allWatchedFiles.values().stream().filter(FileInMemoryDb::isNotYetMarkedAsDone).filter(w -> w.absentInSet(detected)).toList();
        Set<CachedFileAttributes> lostedAndCallbacked = losted.stream().filter(FileInMemoryDb::canBePickupFromType).map(FileInMemoryDb::getLastFile).collect(Collectors.toUnmodifiableSet());
        detected.stream().filter(Predicate.not(this.allWatchedFiles::containsKey)).peek(f -> log.trace("Add to Db: {} ({})", f, (Object)f.hashCode())).forEach(f -> this.allWatchedFiles.put((CachedFileAttributes)f, new FileInMemoryDb((CachedFileAttributes)f, this.pickUp, this.minFixedStateTime)));
        List<CachedFileAttributes> toClean = this.allWatchedFiles.keySet().stream().filter(Predicate.not(detected::contains)).toList();
        toClean.forEach(this.allWatchedFiles::remove);
        log.trace("Lists detected={}, updateFounded={}, updatedChangedFounded={}, qualifyFounded={}, qualifiedAndCallbacked={}, losted={}, lostedAndCallbacked={}, toClean={}", detected, updateFounded, updatedChangedFounded, qualifyFounded, qualifiedAndCallbacked, losted, lostedAndCallbacked, toClean);
        int size = this.pickUp == WatchFolderPickupType.FILES_DIRS ? this.allWatchedFiles.size() : (int)this.allWatchedFiles.values().stream().filter(FileInMemoryDb::canBePickupFromType).count();
        log.debug("Scan result for {}: {} founded, {} lost, {} total", (Object)this.observedFolder.getLabel(), (Object)qualifiedAndCallbacked.size(), (Object)lostedAndCallbacked.size(), (Object)size);
        return new WatchedFiles(qualifiedAndCallbacked, lostedAndCallbacked, updatedChangedFounded, size);
    }

    private void actualScan(AbstractFile aSource, int deep, Set<CachedFileAttributes> detected) {
        Set<String> ignoreFiles = this.observedFolder.getIgnoreFiles();
        boolean allowedHidden = this.observedFolder.isAllowedHidden();
        boolean allowedLinks = this.observedFolder.isAllowedLinks();
        Set<String> allowedExtentions = this.observedFolder.getAllowedExtentions();
        Set<String> blockedExtentions = this.observedFolder.getBlockedExtentions();
        Set<String> ignoreRelativePaths = this.observedFolder.getIgnoreRelativePaths();
        List<CachedFileAttributes> result = aSource.toCachedList().peek(f -> log.trace("Detect file={}", f)).filter(f -> !ignoreFiles.contains(f.getName().toLowerCase())).filter(f -> !(!allowedHidden && (f.isHidden() || f.getName().startsWith(".")))).filter(f -> !(!allowedLinks && f.isLink())).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            if (!allowedExtentions.isEmpty()) {
                return this.containExtension(f.getName(), allowedExtentions);
            }
            return true;
        }).filter(f -> {
            if (f.isDirectory()) {
                return true;
            }
            return !this.containExtension(f.getName(), blockedExtentions);
        }).filter(f -> {
            if (ignoreRelativePaths.isEmpty()) {
                return true;
            }
            return !ignoreRelativePaths.contains(f.getPath());
        }).filter(f -> f.isDirectory() || !f.isSpecial()).toList();
        detected.addAll(result);
        log.debug(() -> "Scanned files/dirs for \"" + aSource.getPath() + "\" (deep " + deep + "): " + result.stream().map(CachedFileAttributes::getName).sorted().collect(Collectors.joining(", ")) + " on \"" + aSource.getFileSystem().toString() + "\"");
        if (deep > 0) {
            result.stream().filter(CachedFileAttributes::isDirectory).forEach(f -> this.actualScan(f.getAbstractFile(), deep - 1, detected));
        }
    }

    boolean containExtension(String baseFileName, Set<String> candidates) {
        return candidates.stream().anyMatch(c -> baseFileName.toLowerCase().endsWith("." + c));
    }
}

