/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import java.time.Duration;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.transfertfiles.CachedFileAttributes;

class WatchedFileInMemoryDb {
    private static final Logger log = LogManager.getLogger();
    private final boolean isDirectory;
    private final boolean pickUpFiles;
    private final boolean pickUpDirs;
    private final Duration minFixedStateTime;
    private CachedFileAttributes lastFile;
    private long lastWatched;
    private boolean markedAsDone;
    private boolean lastIsSame;
    private boolean doneButChanged;

    WatchedFileInMemoryDb(CachedFileAttributes firstDetectionFile, WatchFolderPickupType pickUp, Duration minFixedStateTime) {
        this.lastFile = firstDetectionFile;
        this.isDirectory = firstDetectionFile.isDirectory();
        this.lastWatched = System.currentTimeMillis();
        this.lastIsSame = false;
        this.doneButChanged = false;
        this.pickUpFiles = pickUp.isPickUpFiles();
        this.pickUpDirs = pickUp.isPickUpDirs();
        this.minFixedStateTime = minFixedStateTime;
        log.trace("Create WatchedFileInMemoryDb for {}, {} ({})", (Object)firstDetectionFile, (Object)pickUp, (Object)minFixedStateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lastFile);
        sb.append("{since ");
        sb.append(System.currentTimeMillis() - this.lastWatched);
        sb.append("ms ");
        if (this.markedAsDone) {
            sb.append("markedAsDone ");
        }
        if (this.doneButChanged) {
            sb.append("doneButChanged");
        }
        if (this.lastIsSame) {
            sb.append("lastIsSame ");
        }
        return sb.toString().trim() + "}";
    }

    WatchedFileInMemoryDb update(CachedFileAttributes seeAgainFile) {
        if (this.isDirectory) {
            if (!this.markedAsDone) {
                this.lastFile = seeAgainFile;
            }
        } else {
            boolean bl = this.lastIsSame = this.lastFile.lastModified() == seeAgainFile.lastModified() && this.lastFile.length() == seeAgainFile.length();
            if (!this.lastIsSame) {
                this.lastWatched = System.currentTimeMillis();
                if (this.markedAsDone) {
                    this.doneButChanged = true;
                }
            }
            this.lastFile = seeAgainFile;
        }
        return this;
    }

    boolean isTimeQualified() {
        boolean notTooRecent = this.lastWatched < System.currentTimeMillis() - this.minFixedStateTime.toMillis();
        return this.isDirectory || this.lastIsSame && notTooRecent;
    }

    boolean canBeCallbacked() {
        return this.isTimeQualified() && this.canBePickupFromType();
    }

    boolean canBePickupFromType() {
        return this.isDirectory && this.pickUpDirs || !this.isDirectory && this.pickUpFiles;
    }

    WatchedFileInMemoryDb setMarkedAsDone() {
        this.markedAsDone = true;
        return this;
    }

    boolean isNotYetMarkedAsDone() {
        return !this.markedAsDone;
    }

    boolean isDoneButChanged() {
        return this.doneButChanged;
    }

    WatchedFileInMemoryDb resetDoneButChanged() {
        this.doneButChanged = false;
        return this;
    }

    CachedFileAttributes getLastFile() {
        return this.lastFile;
    }

    boolean absentInSet(Set<CachedFileAttributes> detected) {
        return !detected.contains(this.lastFile);
    }
}

