/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;

public class ObservedFolder {
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String targetFolder;
    private String label;
    private Set<String> allowedExtentions;
    private Set<String> blockedExtentions;
    private Set<String> ignoreRelativePaths;
    private Set<String> ignoreFiles;
    private boolean allowedHidden;
    private boolean allowedLinks;
    private boolean recursive;
    private Duration minFixedStateTime;
    private static final UnaryOperator<String> removeFirstDot = ext -> {
        if (ext.startsWith(".")) {
            return ext.substring(1);
        }
        return ext;
    };

    void postConfiguration() {
        Objects.requireNonNull(this.targetFolder, "Null targetFolder");
        try {
            AbstractFileSystemURL checkParse;
            File targetFolderF = new File(this.targetFolder);
            if (targetFolderF.exists()) {
                String newTargetFolder = "file://localhost" + AbstractFile.normalizePath((String)targetFolderF.getCanonicalFile().getAbsolutePath());
                checkParse = new AbstractFileSystemURL(newTargetFolder);
                this.targetFolder = newTargetFolder;
            } else {
                checkParse = new AbstractFileSystemURL(this.targetFolder);
            }
            checkParse.close();
            if (this.label == null || this.label.isEmpty()) {
                this.label = checkParse.toString();
            }
        }
        catch (IOException e1) {
            throw new UncheckedIOException(new IOException("Can't load: \"" + this.targetFolder + "\""));
        }
        this.allowedExtentions = Optional.ofNullable(this.allowedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.blockedExtentions = Optional.ofNullable(this.blockedExtentions).orElse(Set.of()).stream().map(removeFirstDot).map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreRelativePaths = Optional.ofNullable(this.ignoreRelativePaths).orElse(Set.of()).stream().map(path -> path.replace('\\', '/')).map(AbstractFile::normalizePath).distinct().collect(Collectors.toUnmodifiableSet());
        this.ignoreFiles = Optional.ofNullable(this.ignoreFiles).orElse(Set.of()).stream().map(String::toLowerCase).distinct().collect(Collectors.toUnmodifiableSet());
        this.minFixedStateTime = Optional.ofNullable(this.minFixedStateTime).orElse(Duration.ZERO);
    }

    public String toString() {
        return this.label;
    }

    public AbstractFileSystemURL createFileSystem() {
        return new AbstractFileSystemURL(this.targetFolder);
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getAllowedExtentions() {
        return this.allowedExtentions;
    }

    public Set<String> getBlockedExtentions() {
        return this.blockedExtentions;
    }

    public Set<String> getIgnoreRelativePaths() {
        return this.ignoreRelativePaths;
    }

    public Set<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public boolean isAllowedHidden() {
        return this.allowedHidden;
    }

    public boolean isAllowedLinks() {
        return this.allowedLinks;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Duration getMinFixedStateTime() {
        return this.minFixedStateTime;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAllowedExtentions(Set<String> allowedExtentions) {
        this.allowedExtentions = allowedExtentions;
    }

    public void setBlockedExtentions(Set<String> blockedExtentions) {
        this.blockedExtentions = blockedExtentions;
    }

    public void setIgnoreRelativePaths(Set<String> ignoreRelativePaths) {
        this.ignoreRelativePaths = ignoreRelativePaths;
    }

    public void setIgnoreFiles(Set<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    public void setAllowedHidden(boolean allowedHidden) {
        this.allowedHidden = allowedHidden;
    }

    public void setAllowedLinks(boolean allowedLinks) {
        this.allowedLinks = allowedLinks;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setMinFixedStateTime(Duration minFixedStateTime) {
        this.minFixedStateTime = minFixedStateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObservedFolder)) {
            return false;
        }
        ObservedFolder other = (ObservedFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowedHidden() != other.isAllowedHidden()) {
            return false;
        }
        if (this.isAllowedLinks() != other.isAllowedLinks()) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        String this$targetFolder = this.getTargetFolder();
        String other$targetFolder = other.getTargetFolder();
        if (this$targetFolder == null ? other$targetFolder != null : !this$targetFolder.equals(other$targetFolder)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        Set<String> this$allowedExtentions = this.getAllowedExtentions();
        Set<String> other$allowedExtentions = other.getAllowedExtentions();
        if (this$allowedExtentions == null ? other$allowedExtentions != null : !((Object)this$allowedExtentions).equals(other$allowedExtentions)) {
            return false;
        }
        Set<String> this$blockedExtentions = this.getBlockedExtentions();
        Set<String> other$blockedExtentions = other.getBlockedExtentions();
        if (this$blockedExtentions == null ? other$blockedExtentions != null : !((Object)this$blockedExtentions).equals(other$blockedExtentions)) {
            return false;
        }
        Set<String> this$ignoreRelativePaths = this.getIgnoreRelativePaths();
        Set<String> other$ignoreRelativePaths = other.getIgnoreRelativePaths();
        if (this$ignoreRelativePaths == null ? other$ignoreRelativePaths != null : !((Object)this$ignoreRelativePaths).equals(other$ignoreRelativePaths)) {
            return false;
        }
        Set<String> this$ignoreFiles = this.getIgnoreFiles();
        Set<String> other$ignoreFiles = other.getIgnoreFiles();
        if (this$ignoreFiles == null ? other$ignoreFiles != null : !((Object)this$ignoreFiles).equals(other$ignoreFiles)) {
            return false;
        }
        Duration this$minFixedStateTime = this.getMinFixedStateTime();
        Duration other$minFixedStateTime = other.getMinFixedStateTime();
        return !(this$minFixedStateTime == null ? other$minFixedStateTime != null : !((Object)this$minFixedStateTime).equals(other$minFixedStateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObservedFolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowedHidden() ? 79 : 97);
        result = result * 59 + (this.isAllowedLinks() ? 79 : 97);
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        String $targetFolder = this.getTargetFolder();
        result = result * 59 + ($targetFolder == null ? 43 : $targetFolder.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        Set<String> $allowedExtentions = this.getAllowedExtentions();
        result = result * 59 + ($allowedExtentions == null ? 43 : ((Object)$allowedExtentions).hashCode());
        Set<String> $blockedExtentions = this.getBlockedExtentions();
        result = result * 59 + ($blockedExtentions == null ? 43 : ((Object)$blockedExtentions).hashCode());
        Set<String> $ignoreRelativePaths = this.getIgnoreRelativePaths();
        result = result * 59 + ($ignoreRelativePaths == null ? 43 : ((Object)$ignoreRelativePaths).hashCode());
        Set<String> $ignoreFiles = this.getIgnoreFiles();
        result = result * 59 + ($ignoreFiles == null ? 43 : ((Object)$ignoreFiles).hashCode());
        Duration $minFixedStateTime = this.getMinFixedStateTime();
        result = result * 59 + ($minFixedStateTime == null ? 43 : ((Object)$minFixedStateTime).hashCode());
        return result;
    }
}

