/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder.mod.repository;

import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import tv.hd3g.jobkit.watchfolder.mod.entity.WatchedFileEntity;

public interface WatchedFileEntityRepository
extends JpaRepository<WatchedFileEntity, Long> {
    @Query(value="SELECT w FROM WatchedFileEntity w WHERE w.hashPath IN :hashPath")
    public Set<WatchedFileEntity> getByHashPath(Set<String> var1);

    @Query(value="SELECT w FROM WatchedFileEntity w\nWHERE w.markedAsDone = false\nAND ((w.directory = true AND :pickUpDirs = true) OR (w.directory = false AND :pickUpFiles = true))\nAND w.hashPath NOT IN :detectedHashPath\nAND w.folderLabel = :folderLabel\n")
    public Set<WatchedFileEntity> getLostedByHashPath(Set<String> var1, boolean var2, boolean var3, String var4);

    @Query(value="SELECT w FROM WatchedFileEntity w\nWHERE w.markedAsDone = false\nAND ((w.directory = true AND :pickUpDirs = true) OR (w.directory = false AND :pickUpFiles = true))\nAND w.folderLabel = :folderLabel\n")
    public Set<WatchedFileEntity> getLostedForEmptyDir(boolean var1, boolean var2, String var3);

    @Query(value="SELECT w.hashPath FROM WatchedFileEntity w WHERE w.folderLabel = :folderLabel")
    public Set<String> getAllHashPathByFolderLabel(String var1);

    @Query(value="DELETE FROM WatchedFileEntity WHERE hashPath IN :detectedHashPath")
    @Modifying
    public void deleteByHashPath(Set<String> var1);

    @Query(value="SELECT COUNT(w) FROM WatchedFileEntity w WHERE w.folderLabel = :folderLabel")
    public int countByFolderLabel(String var1);

    @Query(value="SELECT COUNT(w) FROM WatchedFileEntity w\nWHERE ((w.directory = true AND :pickUpDirs = true) OR (w.directory = false AND :pickUpFiles = true))\nAND w.folderLabel = :folderLabel\n")
    public int countByFolderLabel(boolean var1, boolean var2, String var3);

    @Query(value="DELETE FROM WatchedFileEntity WHERE folderLabel NOT IN :folderLabelToKeep")
    @Modifying
    public void deleteFolderLabelsNotInSet(Set<String> var1);
}

