/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder.mod.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.sql.Timestamp;
import java.time.Duration;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.type.NumericBooleanConverter;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.mod.entity.BaseEntity;
import tv.hd3g.transfertfiles.CachedFileAttributes;
import tv.hd3g.transfertfiles.FileAttributesReference;

@Entity
@Table(name="jobkit_wf_watchedfile", indexes={@Index(columnList="hash_path", name="jobkit_wf_watchedfile_hash_path_idx"), @Index(columnList="folder_label", name="jobkit_wf_watchedfile_folder_label_idx")})
public class WatchedFileEntity
extends BaseEntity {
    public static final String TABLE_NAME = "jobkit_wf_watchedfile";
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(columnDefinition="TINYINT")
    private boolean directory;
    @NotBlank
    @Column(length=64, name="folder_label", updatable=false)
    private String folderLabel;
    @NotBlank
    @Column(length=4096, updatable=false)
    private String path;
    @NotBlank
    @Column(length=32, name="hash_path", updatable=false)
    private String hashPath;
    @NotNull
    @Column(name="last_modified")
    private Timestamp lastModified;
    @NotNull
    @Column(name="last_length")
    private Long lastLength;
    @NotNull
    @Column(name="last_watched")
    private Timestamp lastWatched;
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(name="marked_as_done", columnDefinition="TINYINT")
    private boolean markedAsDone;
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(name="last_is_same", columnDefinition="TINYINT")
    private boolean lastIsSame;
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(name="done_but_changed", columnDefinition="TINYINT")
    private boolean doneButChanged;

    public WatchedFileEntity() {
    }

    public WatchedFileEntity(CachedFileAttributes firstDetectionFile, ObservedFolder observedFolder) {
        this.initCreate();
        String label = observedFolder.getLabel();
        this.folderLabel = label.substring(0, Math.min(64, label.length()));
        this.path = firstDetectionFile.getPath();
        this.hashPath = WatchedFileEntity.hashPath(observedFolder.getLabel(), firstDetectionFile.getPath());
        this.refreshNewFile(firstDetectionFile);
        this.directory = firstDetectionFile.isDirectory();
        this.lastWatched = new Timestamp(System.currentTimeMillis());
        this.lastIsSame = false;
        this.doneButChanged = false;
        this.markedAsDone = false;
    }

    public static final String hashPath(String observedFolderLabel, String path) {
        return DigestUtils.md5Hex((String)(observedFolderLabel + ":" + path));
    }

    private void refreshNewFile(CachedFileAttributes file) {
        this.lastModified = new Timestamp(file.lastModified());
        this.lastLength = file.length();
    }

    public WatchedFileEntity update(CachedFileAttributes seeAgainFile) {
        if (this.directory) {
            if (!this.markedAsDone) {
                this.refreshNewFile(seeAgainFile);
            }
        } else {
            boolean bl = this.lastIsSame = this.lastModified.getTime() == seeAgainFile.lastModified() && this.lastLength.longValue() == seeAgainFile.length();
            if (!this.lastIsSame) {
                this.lastWatched = new Timestamp(System.currentTimeMillis());
                if (this.markedAsDone) {
                    this.doneButChanged = true;
                }
            }
            this.refreshNewFile(seeAgainFile);
        }
        return this;
    }

    public boolean isTimeQualified(Duration minFixedStateTime) {
        boolean notTooRecent = this.lastWatched.getTime() < System.currentTimeMillis() - minFixedStateTime.toMillis();
        return this.directory || this.lastIsSame && notTooRecent;
    }

    public boolean canBePickupFromType(WatchFolderPickupType pickUp) {
        return this.directory && pickUp.isPickUpDirs() || !this.directory && pickUp.isPickUpFiles();
    }

    public WatchedFileEntity resetDoneButChanged() {
        this.doneButChanged = false;
        return this;
    }

    public WatchedFileEntity setMarkedAsDone() {
        this.markedAsDone = true;
        return this;
    }

    public FileAttributesReference toFileAttributesReference(boolean exists) {
        return new FileAttributesReference(this.path, this.lastLength.longValue(), this.lastModified.getTime(), exists, this.directory);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WatchedFileEntity [directory=");
        builder.append(this.directory);
        builder.append(", folderLabel=");
        builder.append(this.folderLabel);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", hashPath=");
        builder.append(this.hashPath);
        builder.append(", lastModified=");
        builder.append(this.lastModified);
        builder.append(", lastLength=");
        builder.append(this.lastLength);
        builder.append(", lastWatched=");
        builder.append(this.lastWatched);
        builder.append(", markedAsDone=");
        builder.append(this.markedAsDone);
        builder.append(", lastIsSame=");
        builder.append(this.lastIsSame);
        builder.append(", doneButChanged=");
        builder.append(this.doneButChanged);
        builder.append("]");
        return builder.toString();
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public String getFolderLabel() {
        return this.folderLabel;
    }

    public String getPath() {
        return this.path;
    }

    public String getHashPath() {
        return this.hashPath;
    }

    public Timestamp getLastModified() {
        return this.lastModified;
    }

    public Long getLastLength() {
        return this.lastLength;
    }

    public Timestamp getLastWatched() {
        return this.lastWatched;
    }

    public boolean isMarkedAsDone() {
        return this.markedAsDone;
    }

    public boolean isLastIsSame() {
        return this.lastIsSame;
    }

    public boolean isDoneButChanged() {
        return this.doneButChanged;
    }

    public void setLastModified(Timestamp lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastLength(Long lastLength) {
        this.lastLength = lastLength;
    }

    public void setLastWatched(Timestamp lastWatched) {
        this.lastWatched = lastWatched;
    }

    public void setMarkedAsDone(boolean markedAsDone) {
        this.markedAsDone = markedAsDone;
    }

    public void setLastIsSame(boolean lastIsSame) {
        this.lastIsSame = lastIsSame;
    }

    public void setDoneButChanged(boolean doneButChanged) {
        this.doneButChanged = doneButChanged;
    }
}

