/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.jobkit.watchfolder.mod.service;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tv.hd3g.jobkit.watchfolder.ObservedFolder;
import tv.hd3g.jobkit.watchfolder.WatchFolderPickupType;
import tv.hd3g.jobkit.watchfolder.WatchedFileSetupManager;
import tv.hd3g.jobkit.watchfolder.WatchedFiles;
import tv.hd3g.jobkit.watchfolder.mod.component.WatchedFileScannerSupplier;
import tv.hd3g.jobkit.watchfolder.mod.entity.WatchedFileEntity;
import tv.hd3g.jobkit.watchfolder.mod.repository.WatchedFileEntityRepository;
import tv.hd3g.jobkit.watchfolder.mod.service.WatchedFilesDbService;
import tv.hd3g.transfertfiles.AbstractFileSystemURL;
import tv.hd3g.transfertfiles.CachedFileAttributes;

@Service
public class WatchedFilesDbServiceImpl
implements WatchedFilesDbService {
    private static Logger log = LogManager.getLogger();
    @Autowired
    private WatchedFileSetupManager watchedFileSetupManager;
    @Autowired
    private WatchedFileEntityRepository watchedFileEntityRepository;
    @Autowired
    private WatchedFileScannerSupplier watchedFileScannerSupplier;

    public void setup(ObservedFolder observedFolder, WatchFolderPickupType pickUp) {
        this.watchedFileSetupManager.put(observedFolder, this.watchedFileScannerSupplier.create(observedFolder), pickUp);
    }

    @Override
    @Transactional
    public void purgeOlderWF(Collection<ObservedFolder> currentObservedFolders) {
        if (currentObservedFolders.isEmpty()) {
            return;
        }
        Set<String> folderLabelToKeep = currentObservedFolders.stream().map(ObservedFolder::getLabel).collect(Collectors.toUnmodifiableSet());
        this.watchedFileEntityRepository.deleteFolderLabelsNotInSet(folderLabelToKeep);
    }

    @Transactional
    public WatchedFiles update(ObservedFolder observedFolder, AbstractFileSystemURL fileSystem) {
        String folderLabel = observedFolder.getLabel();
        Duration minFixedStateTime = observedFolder.getMinFixedStateTime();
        WatchedFileSetupManager.WatchedFileScannerProviderEntry watchedFileScannerProviderEntry = this.watchedFileSetupManager.get(observedFolder);
        Set<String> allWatchedFilesHashPath = this.watchedFileEntityRepository.getAllHashPathByFolderLabel(folderLabel);
        WatchFolderPickupType pickUp = watchedFileScannerProviderEntry.pickUp();
        List detected = watchedFileScannerProviderEntry.scanner().scan(fileSystem);
        Map<String, CachedFileAttributes> detectedByhashKey = detected.stream().collect(Collectors.toUnmodifiableMap(d -> WatchedFileEntity.hashPath(folderLabel, d.getPath()), d -> d));
        log.trace("detectedByhashKey={}", detectedByhashKey);
        Map<Object, Object> entitiesByHashKey = !detectedByhashKey.isEmpty() ? this.watchedFileEntityRepository.getByHashPath(detectedByhashKey.keySet()).stream().collect(Collectors.toUnmodifiableMap(WatchedFileEntity::getHashPath, wf -> wf)) : new HashMap();
        List<WatchedFileEntity> updateFounded = entitiesByHashKey.entrySet().stream().map(entry -> ((WatchedFileEntity)entry.getValue()).update((CachedFileAttributes)detectedByhashKey.get(entry.getKey()))).toList();
        Set updatedChangedFounded = updateFounded.stream().filter(WatchedFileEntity::isMarkedAsDone).filter(u -> u.isTimeQualified(minFixedStateTime)).filter(u -> u.canBePickupFromType(pickUp)).filter(WatchedFileEntity::isDoneButChanged).map(WatchedFileEntity::resetDoneButChanged).map(WatchedFileEntity::getHashPath).map(detectedByhashKey::get).collect(Collectors.toUnmodifiableSet());
        List<WatchedFileEntity> qualifyFounded = updateFounded.stream().filter(Predicate.not(WatchedFileEntity::isMarkedAsDone)).filter(u -> u.isTimeQualified(minFixedStateTime)).map(WatchedFileEntity::setMarkedAsDone).toList();
        Set qualifiedAndCallbacked = qualifyFounded.stream().filter(u -> u.isTimeQualified(minFixedStateTime)).filter(u -> u.canBePickupFromType(pickUp)).map(WatchedFileEntity::getHashPath).map(detectedByhashKey::get).collect(Collectors.toUnmodifiableSet());
        Set lostedAndCallbacked = !detectedByhashKey.isEmpty() ? this.watchedFileEntityRepository.getLostedByHashPath(detectedByhashKey.keySet(), pickUp.isPickUpDirs(), pickUp.isPickUpFiles(), folderLabel).stream().map(f -> f.toFileAttributesReference(false)).collect(Collectors.toUnmodifiableSet()) : this.watchedFileEntityRepository.getLostedForEmptyDir(pickUp.isPickUpDirs(), pickUp.isPickUpFiles(), folderLabel).stream().map(f -> f.toFileAttributesReference(false)).collect(Collectors.toUnmodifiableSet());
        List<WatchedFileEntity> addNewEntites = detected.stream().filter(f -> !allWatchedFilesHashPath.contains(WatchedFileEntity.hashPath(folderLabel, f.getPath()))).peek(f -> log.trace("Add to Db: {} ({})", f, (Object)f.hashCode())).map(f -> new WatchedFileEntity((CachedFileAttributes)f, observedFolder)).toList();
        if (!addNewEntites.isEmpty()) {
            this.watchedFileEntityRepository.saveAll(addNewEntites);
        }
        Set<String> toClean = allWatchedFilesHashPath.stream().filter(Predicate.not(detectedByhashKey::containsKey)).collect(Collectors.toUnmodifiableSet());
        if (!toClean.isEmpty()) {
            this.watchedFileEntityRepository.deleteByHashPath(toClean);
        }
        log.trace("Lists detected={}, updateFounded={}, updatedChangedFounded={}, qualifyFounded={}, qualifiedAndCallbacked={}, lostedAndCallbacked={}, toClean={}", (Object)detected, updateFounded, updatedChangedFounded, qualifyFounded, qualifiedAndCallbacked, lostedAndCallbacked, toClean);
        int size = pickUp == WatchFolderPickupType.FILES_DIRS ? this.watchedFileEntityRepository.countByFolderLabel(folderLabel) : this.watchedFileEntityRepository.countByFolderLabel(pickUp.isPickUpDirs(), pickUp.isPickUpFiles(), folderLabel);
        log.debug("Scan watchedFilesResult for {}: {} founded, {} lost, {} total", (Object)observedFolder.getLabel(), (Object)qualifiedAndCallbacked.size(), (Object)lostedAndCallbacked.size(), (Object)size);
        return new WatchedFiles(qualifiedAndCallbacked, lostedAndCallbacked, updatedChangedFounded, size);
    }

    @Transactional
    public void reset(ObservedFolder observedFolder, Set<CachedFileAttributes> foundedFiles) {
        if (foundedFiles.isEmpty()) {
            throw new IllegalArgumentException("foundedFiles can't to be empty");
        }
        Set<String> hashPathListToPurge = foundedFiles.stream().map(ff -> WatchedFileEntity.hashPath(observedFolder.getLabel(), ff.getPath())).collect(Collectors.toUnmodifiableSet());
        this.watchedFileEntityRepository.deleteByHashPath(hashPathListToPurge);
    }
}

