/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.ffprobejaxb.FFprobeReference;
import tv.hd3g.ffprobejaxb.data.FFProbeChapter;
import tv.hd3g.ffprobejaxb.data.FFProbeFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeKeyValue;
import tv.hd3g.ffprobejaxb.data.FFProbeStream;

public record MediaSummary(String format, List<String> streams) {
    private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);

    static MediaSummary create(FFprobeJAXB source) {
        FFProbeFormat format = source.getFormat().orElseThrow(() -> new IllegalArgumentException("Can't found FFprobe format to produce Summary"));
        List<FFProbeChapter> chapters = source.getChapters();
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(format.formatLongName());
        entries.add(MediaSummary.computeDuration(format));
        source.getTimecode(true).map(t -> "TCIN: " + t).ifPresent(entries::add);
        if (format.size() <= 0x100000L) {
            entries.add(format.size() + " bytes");
        } else {
            entries.add(format.size() / 1024L / 1024L + " MB");
        }
        if (format.nbPrograms() > 0) {
            entries.add(format.nbPrograms() + " program" + (format.nbPrograms() > 1 ? "s" : ""));
        }
        if (!chapters.isEmpty()) {
            entries.add(chapters.size() + " chapter" + (chapters.size() > 1 ? "s" : ""));
        }
        if (!source.getVideoStreams().anyMatch(f -> f.bitRate() > 0) && !source.getAudioStreams().anyMatch(f -> f.bitRate() > 0)) {
            Optional.ofNullable(format.bitRate()).ifPresent(b -> {
                double bitrateKbps = (double)b.longValue() / 1000.0;
                if (bitrateKbps < 10000.0) {
                    entries.add(Math.round(bitrateKbps) + " kbps");
                } else {
                    entries.add(Math.round(bitrateKbps / 1000.0) + " Mbps");
                }
            });
        }
        Stream<String> videos = source.getVideoStreams().map(MediaSummary::getVideoSummary);
        Stream<String> audios = source.getAudioStreams().map(MediaSummary::getAudioSummary);
        Stream<String> others = MediaSummary.computeOther(source);
        return new MediaSummary(entries.stream().collect(Collectors.joining(", ")), Stream.of(videos, audios, others).flatMap(s -> s).toList());
    }

    static Optional<String> getValue(String value) {
        return Optional.ofNullable(value).flatMap(v -> {
            if (v.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable(v);
        });
    }

    static String getAudioSummary(FFProbeStream s) {
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(s.codecType() + ": " + s.codecName());
        MediaSummary.getValue(s.profile()).ifPresent(entries::add);
        MediaSummary.getValue(s.sampleFmt()).flatMap(f -> {
            if (f.equals("fltp") || f.equals("s16p") || s.codecName().contains((CharSequence)f)) {
                return Optional.empty();
            }
            return Optional.ofNullable(f);
        }).ifPresent(entries::add);
        if (s.channels() > 2) {
            if (s.channelLayout() != null) {
                entries.add(s.channelLayout() + " (" + s.channels() + " channels)");
            } else {
                entries.add(s.channels() + " channels");
            }
        } else if (s.channelLayout() != null) {
            entries.add(s.channelLayout());
        } else if (s.channels() == 2) {
            entries.add("2 channels");
        } else {
            entries.add("mono");
        }
        Optional.ofNullable(s.sampleRate()).ifPresent(sr -> entries.add("@ " + sr + " Hz"));
        Optional.ofNullable(s.bitRate()).filter(b -> b > 100).ifPresent(b -> entries.add("[" + b / 1000 + " kbps]"));
        String dispositions = s.disposition().resumeDispositions().collect(Collectors.joining(", "));
        if (!dispositions.isEmpty()) {
            entries.add(dispositions);
        }
        return entries.stream().collect(Collectors.joining(" "));
    }

    static String getVideoSummary(FFProbeStream s) {
        String dispositions;
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(s.codecType() + ": " + s.codecName());
        if (s.width() > 0 && s.height() > 0) {
            entries.add(s.width() + "\u00d7" + s.height());
        }
        Optional<String> profile = MediaSummary.getValue(s.profile()).filter(p -> !p.equals("0"));
        Integer level = Optional.ofNullable(s.level()).orElse(0);
        if (profile.isPresent()) {
            if (level > 0) {
                entries.add(profile.get() + "/" + MediaSummary.getLevelTag(s.codecName(), level));
            } else {
                entries.add(profile.get());
            }
        } else if (level > 0) {
            entries.add(MediaSummary.getLevelTag(s.codecName(), level));
        }
        if (s.hasBFrames()) {
            entries.add("with B frames");
        }
        String frameRate = MediaSummary.getValue(s.avgFrameRate()).map(b -> {
            int pos = b.indexOf("/");
            if (pos == -1) {
                return b;
            }
            Double l = Double.valueOf(b.substring(0, pos));
            Double r = Double.valueOf(b.substring(pos + 1));
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(symbols);
            df.setMaximumFractionDigits(3);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(false);
            return df.format(l / r);
        }).orElse("?");
        entries.add("@ " + frameRate + " fps");
        Optional.ofNullable(s.bitRate()).ifPresent(b -> {
            double bitrateKbps = (double)b.intValue() / 1000.0;
            if (bitrateKbps < 1.0) {
                return;
            }
            if (bitrateKbps < 10000.0) {
                entries.add("[" + Math.round(bitrateKbps) + " kbps]");
            } else {
                entries.add("[" + Math.round(bitrateKbps / 1000.0) + " Mbps]");
            }
        });
        String cpf = MediaSummary.computePixelsFormat(s);
        if (!cpf.isEmpty()) {
            entries.add(cpf);
        }
        if (s.hasBFrames() && s.nbFrames() > 0) {
            entries.add("(" + s.nbFrames() + " frms)");
        }
        if (!(dispositions = s.disposition().resumeDispositions().collect(Collectors.joining(", "))).isEmpty()) {
            entries.add(dispositions);
        }
        return entries.stream().collect(Collectors.joining(" "));
    }

    public static String getLevelTag(String videoCodec, int rawLevel) {
        return switch (videoCodec) {
            case "mpeg1video", "mpeg2video", "mpegvideo" -> {
                switch (rawLevel) {
                    case 4: {
                        yield "High";
                    }
                    case 6: {
                        yield "High 1440";
                    }
                    case 8: {
                        yield "Main";
                    }
                    case 10: {
                        yield "Low";
                    }
                }
                yield "L" + rawLevel;
            }
            case "h264", "avc" -> {
                switch (rawLevel) {
                    case 10: {
                        yield "1";
                    }
                    case 9: {
                        yield "1b";
                    }
                    case 11: {
                        yield "1.1";
                    }
                    case 12: {
                        yield "1.2";
                    }
                    case 13: {
                        yield "1.3";
                    }
                    case 20: {
                        yield "2";
                    }
                    case 21: {
                        yield "2.1";
                    }
                    case 22: {
                        yield "2.2";
                    }
                    case 30: {
                        yield "3";
                    }
                    case 31: {
                        yield "3.1";
                    }
                    case 32: {
                        yield "3.2";
                    }
                    case 40: {
                        yield "4";
                    }
                    case 41: {
                        yield "4.1";
                    }
                    case 42: {
                        yield "4.2";
                    }
                    case 50: {
                        yield "5";
                    }
                    case 51: {
                        yield "5.1";
                    }
                    case 52: {
                        yield "5.2";
                    }
                    case 60: {
                        yield "6";
                    }
                    case 61: {
                        yield "6.1";
                    }
                    case 62: {
                        yield "6.2";
                    }
                }
                yield "L" + rawLevel;
            }
            case "hevc", "h265" -> {
                switch (rawLevel) {
                    case 30: {
                        yield "1";
                    }
                    case 60: {
                        yield "2";
                    }
                    case 63: {
                        yield "2.1";
                    }
                    case 90: {
                        yield "3";
                    }
                    case 93: {
                        yield "3.1";
                    }
                    case 120: {
                        yield "4";
                    }
                    case 123: {
                        yield "4.1";
                    }
                    case 150: {
                        yield "5";
                    }
                    case 153: {
                        yield "5.1";
                    }
                    case 156: {
                        yield "5.2";
                    }
                    case 180: {
                        yield "6";
                    }
                    case 183: {
                        yield "6.1";
                    }
                    case 186: {
                        yield "6.2";
                    }
                    case 255: {
                        yield "8.5";
                    }
                }
                yield "L" + rawLevel;
            }
            case "av1" -> {
                switch (rawLevel) {
                    case 20: {
                        yield "2.0";
                    }
                    case 21: {
                        yield "2.1";
                    }
                    case 22: {
                        yield "2.2";
                    }
                    case 23: {
                        yield "2.3";
                    }
                    case 30: {
                        yield "3.0";
                    }
                    case 31: {
                        yield "3.1";
                    }
                    case 32: {
                        yield "3.2";
                    }
                    case 33: {
                        yield "3.3";
                    }
                    case 40: {
                        yield "4.0";
                    }
                    case 41: {
                        yield "4.1";
                    }
                    case 42: {
                        yield "4.2";
                    }
                    case 43: {
                        yield "4.3";
                    }
                    case 50: {
                        yield "5.0";
                    }
                    case 51: {
                        yield "5.1";
                    }
                    case 52: {
                        yield "5.2";
                    }
                    case 53: {
                        yield "5.3";
                    }
                    case 60: {
                        yield "6.0";
                    }
                    case 61: {
                        yield "6.1";
                    }
                    case 62: {
                        yield "6.2";
                    }
                    case 63: {
                        yield "6.3";
                    }
                    case 70: {
                        yield "7.0";
                    }
                    case 71: {
                        yield "7.1";
                    }
                    case 72: {
                        yield "7.2";
                    }
                    case 73: {
                        yield "7.3";
                    }
                }
                yield "L" + rawLevel;
            }
            default -> "L" + rawLevel;
        };
    }

    static String computePixelsFormat(FFProbeStream s) {
        ArrayList entries = new ArrayList();
        MediaSummary.getValue(s.pixFmt()).ifPresent(entries::add);
        MediaSummary.getValue(s.colorRange()).map(v -> "colRange:" + v.toUpperCase()).ifPresent(entries::add);
        Optional<String> oColorSpace = MediaSummary.getValue(s.colorSpace());
        Optional<String> oColorTransfer = MediaSummary.getValue(s.colorTransfer());
        Optional<String> oColorPrimaries = MediaSummary.getValue(s.colorPrimaries());
        if (oColorSpace.isPresent() && oColorSpace.equals(oColorTransfer) && oColorSpace.equals(oColorPrimaries)) {
            oColorSpace.map(String::toUpperCase).ifPresent(entries::add);
        } else {
            Stream.of(oColorSpace.map(v -> "colSpace:" + v.toUpperCase()).stream(), oColorTransfer.map(v -> "colTransfer:" + v.toUpperCase()).stream(), oColorPrimaries.map(v -> "colPrimaries:" + v.toUpperCase()).stream()).flatMap(f -> f).forEach(entries::add);
        }
        return entries.stream().collect(Collectors.joining("/"));
    }

    static void addZeros(int value, StringBuilder sbTime) {
        if (value < 10) {
            sbTime.append("0");
        }
        sbTime.append(value);
    }

    public static String computeDuration(FFProbeFormat format) {
        Duration duration = Duration.ofMillis(Math.round(format.duration() * 1000.0f));
        StringBuilder sbTime = new StringBuilder();
        MediaSummary.addZeros(duration.toHoursPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toMinutesPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toSecondsPart(), sbTime);
        return sbTime.toString();
    }

    private static Stream<String> computeOther(FFprobeJAXB source) {
        return source.getStreams().stream().filter(Predicate.not(FFprobeReference.filterAudioStream)).filter(Predicate.not(FFprobeReference.filterVideoStream)).map(v -> {
            String name = MediaSummary.getValue(v.codecName()).or(() -> MediaSummary.getValue(v.codecTagString())).orElse("");
            String handler = v.tags().stream().filter(t -> "handler_name".equals(t.key())).findFirst().map(FFProbeKeyValue::value).map(t -> " (" + t + ")").orElse("");
            return v.codecType() + ": " + name + handler;
        });
    }

    @Override
    public String toString() {
        ToIntFunction<String> computeHeaders = v -> {
            if (v.contains("video: ")) {
                return 0;
            }
            if (v.contains("audio: ")) {
                return 1;
            }
            return 2;
        };
        ToIntFunction<String> computeBitrate = v -> {
            int from = v.indexOf("[");
            int toK = v.indexOf("kbps]");
            int toM = v.indexOf("Mbps]");
            if (from == -1 || toK == -1 && toM == -1) {
                return 0;
            }
            if (toK > -1) {
                return Integer.valueOf(v.substring(from + 1, toK - 1));
            }
            return Integer.valueOf(v.substring(from + 1, toM - 1)) * 1000;
        };
        String streamsCollected = this.streams.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().map(entry -> {
            if ((Long)entry.getValue() > 1L) {
                return entry.getValue() + "\u00d7 " + (String)entry.getKey();
            }
            return (String)entry.getKey();
        }).sorted((l, r) -> {
            int rV;
            int lV = computeHeaders.applyAsInt((String)l);
            if (lV == (rV = computeHeaders.applyAsInt((String)r))) {
                return Integer.compare(computeBitrate.applyAsInt((String)r), computeBitrate.applyAsInt((String)l));
            }
            return Integer.compare(lV, rV);
        }).collect(Collectors.joining(", "));
        return this.format + ", " + streamsCollected;
    }
}

