/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tv.hd3g.ffprobejaxb.data.FFProbeChapter;
import tv.hd3g.ffprobejaxb.data.FFProbeError;
import tv.hd3g.ffprobejaxb.data.FFProbeFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeKeyValue;
import tv.hd3g.ffprobejaxb.data.FFProbeLibraryVersion;
import tv.hd3g.ffprobejaxb.data.FFProbePixelFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeProgram;
import tv.hd3g.ffprobejaxb.data.FFProbeProgramVersion;
import tv.hd3g.ffprobejaxb.data.FFProbeStream;

public interface FFprobeReference {
    public static final Predicate<FFProbeStream> filterVideoStream = streamType -> streamType.codecType().equals("video");
    public static final Predicate<FFProbeStream> filterAudioStream = streamType -> streamType.codecType().equals("audio");
    public static final Predicate<FFProbeStream> filterDataStream = streamType -> streamType.codecType().equals("data");

    public Optional<FFProbeFormat> getFormat();

    public List<FFProbeStream> getStreams();

    public String getXmlContent();

    public String getXSDVersionReference();

    public List<FFProbeLibraryVersion> getLibraryVersions();

    public Optional<FFProbeError> getError();

    public List<FFProbeProgram> getPrograms();

    public Optional<FFProbeProgramVersion> getProgramVersion();

    public List<FFProbeChapter> getChapters();

    public List<FFProbePixelFormat> getPixelFormats();

    default public Stream<FFProbeStream> getVideoStreams() {
        return this.getStreams().stream().filter(filterVideoStream);
    }

    default public Stream<FFProbeStream> getAudioStreams() {
        return this.getStreams().stream().filter(filterAudioStream);
    }

    default public Optional<FFProbeStream> getFirstVideoStream() {
        return this.getVideoStreams().filter(vs -> !vs.disposition().attachedPic()).filter(vs -> !vs.disposition().timedThumbnails()).filter(vs -> !vs.disposition().stillImage()).sorted((l, r) -> Boolean.compare(r.disposition().asDefault(), l.disposition().asDefault())).findFirst();
    }

    default public Optional<String> getTimecode(boolean discard0TC) {
        return Stream.concat(this.getFormat().stream().map(FFProbeFormat::tags), this.getStreams().stream().map(FFProbeStream::tags)).flatMap(Collection::stream).filter(t -> "timecode".equals(t.key())).map(FFProbeKeyValue::value).findFirst().filter(tc -> !tc.equals("00:00:00:00") || !discard0TC);
    }
}

