/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ffmpeg.ffprobe700.ChapterType;
import org.ffmpeg.ffprobe700.FfprobeType;
import org.ffmpeg.ffprobe700.LibraryVersionType;
import org.ffmpeg.ffprobe700.PacketSideDataType;
import org.ffmpeg.ffprobe700.PixelFormatComponentType;
import org.ffmpeg.ffprobe700.PixelFormatFlagsType;
import org.ffmpeg.ffprobe700.PixelFormatType;
import org.ffmpeg.ffprobe700.ProgramType;
import org.ffmpeg.ffprobe700.StreamType;
import org.ffmpeg.ffprobe700.StreamsType;
import org.ffmpeg.ffprobe700.TagType;
import org.ffmpeg.ffprobe700.TagsType;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.ffprobejaxb.data.FFProbeChapter;
import tv.hd3g.ffprobejaxb.data.FFProbeError;
import tv.hd3g.ffprobejaxb.data.FFProbeFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeKeyValue;
import tv.hd3g.ffprobejaxb.data.FFProbeLibraryVersion;
import tv.hd3g.ffprobejaxb.data.FFProbePacketSideData;
import tv.hd3g.ffprobejaxb.data.FFProbePixelFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeProgram;
import tv.hd3g.ffprobejaxb.data.FFProbeProgramVersion;
import tv.hd3g.ffprobejaxb.data.FFProbeStream;
import tv.hd3g.ffprobejaxb.data.FFProbeStreamDisposition;

public class FFprobeJAXB700
extends FFprobeJAXB {
    private FfprobeType ffprobe;

    protected FFprobeJAXB700(String xmlContent) {
        super(xmlContent);
    }

    @Override
    protected void setJAXB(Object rawJAXB) {
        this.ffprobe = (FfprobeType)rawJAXB;
    }

    @Override
    public String getXSDVersionReference() {
        String pname = this.ffprobe.getClass().getPackageName();
        return pname.substring(pname.lastIndexOf(".") + 1);
    }

    @Override
    public List<FFProbeLibraryVersion> getLibraryVersions() {
        return FFprobeJAXB700.getSubList(this.ffprobe.getLibraryVersions(), LibraryVersionType.class).map(f -> new FFProbeLibraryVersion(f.getName(), f.getMajor(), f.getMinor(), f.getMicro(), f.getVersion(), f.getIdent())).toList();
    }

    @Override
    public Optional<FFProbeProgramVersion> getProgramVersion() {
        return Optional.ofNullable(this.ffprobe.getProgramVersion()).map(p -> new FFProbeProgramVersion(p.getVersion(), p.getCopyright(), p.getBuildDate(), p.getBuildTime(), p.getCompilerIdent(), p.getConfiguration()));
    }

    @Override
    public Optional<FFProbeError> getError() {
        return Optional.ofNullable(this.ffprobe.getError()).map(e -> new FFProbeError(e.getCode(), e.getString()));
    }

    private static List<FFProbeKeyValue> getTags(TagsType tagsType) {
        return FFprobeJAXB700.getSubList(tagsType, TagType.class).map(t -> new FFProbeKeyValue(t.getKey(), t.getValue())).toList();
    }

    @Override
    public Optional<FFProbeFormat> getFormat() {
        return Optional.ofNullable(this.ffprobe.getFormat()).map(f -> new FFProbeFormat(FFprobeJAXB700.getTags(f.getTags()), f.getFilename(), f.getNbStreams(), f.getNbPrograms(), f.getFormatName(), f.getFormatLongName(), FFprobeJAXB700.getNonNull(f.getStartTime()), FFprobeJAXB700.getNonNull(f.getDuration()), FFprobeJAXB700.getNonNull(f.getSize()), FFprobeJAXB700.getNonNull(f.getBitRate()), FFprobeJAXB700.getNonNull(f.getProbeScore())));
    }

    private static List<FFProbeKeyValue> getChapterTags(ChapterType c) {
        return c.getTags().stream().flatMap(t -> Optional.ofNullable(t.getTag()).stream().flatMap(Collection::stream)).map(t -> new FFProbeKeyValue(t.getKey(), t.getValue())).toList();
    }

    @Override
    public List<FFProbeChapter> getChapters() {
        return FFprobeJAXB700.getSubList(this.ffprobe.getChapters(), ChapterType.class).map(c -> new FFProbeChapter(FFprobeJAXB700.getChapterTags(c), c.getId(), c.getTimeBase(), c.getStart(), c.getStartTime().floatValue(), c.getEnd(), c.getEndTime())).toList();
    }

    private static FFProbeStreamDisposition getDispositions(StreamType s) {
        return Optional.ofNullable(s.getDisposition()).map(d -> new FFProbeStreamDisposition(d.getDefault() == 1, d.getDub() == 1, d.getOriginal() == 1, d.getComment() == 1, d.getLyrics() == 1, d.getKaraoke() == 1, d.getForced() == 1, d.getHearingImpaired() == 1, d.getVisualImpaired() == 1, d.getCleanEffects() == 1, d.getAttachedPic() == 1, d.getTimedThumbnails() == 1, d.getNonDiegetic() == 1, d.getCaptions() == 1, d.getDescriptions() == 1, d.getMetadata() == 1, d.getDependent() == 1, d.getStillImage() == 1)).orElseGet(() -> FFProbeStreamDisposition.getByNames(new String[0]));
    }

    private static List<FFProbePacketSideData> getSideDataList(StreamType s) {
        return FFprobeJAXB700.getSubList(s.getSideDataList(), PacketSideDataType.class).map(sdl -> new FFProbePacketSideData(sdl.getSideDatum().stream().map(sd -> new FFProbeKeyValue(sd.getKey(), sd.getValue())).toList(), sdl.getType(), 0)).toList();
    }

    private static List<FFProbeStream> getStreams(StreamsType streamsType) {
        return FFprobeJAXB700.getSubList(streamsType, StreamType.class).map(s -> new FFProbeStream(FFprobeJAXB700.getDispositions(s), FFprobeJAXB700.getTags(s.getTags()), FFprobeJAXB700.getSideDataList(s), s.getIndex(), s.getCodecName(), s.getCodecLongName(), s.getProfile(), s.getCodecType(), s.getCodecTag(), s.getCodecTagString(), s.getExtradata(), s.getExtradataSize() != null ? s.getExtradataSize() : 0, s.getExtradataHash(), FFprobeJAXB700.getNonNull(s.getWidth()), FFprobeJAXB700.getNonNull(s.getHeight()), FFprobeJAXB700.getNonNull(s.getCodedWidth()), FFprobeJAXB700.getNonNull(s.getCodedHeight()), FFprobeJAXB700.getNonNull(s.isClosedCaptions()), FFprobeJAXB700.getNonNull(s.isFilmGrain()), s.getHasBFrames() != null && s.getHasBFrames() > 0, s.getSampleAspectRatio(), s.getDisplayAspectRatio(), s.getPixFmt(), FFprobeJAXB700.getNonNull(s.getLevel()), s.getColorRange(), s.getColorSpace(), s.getColorTransfer(), s.getColorPrimaries(), s.getChromaLocation(), s.getFieldOrder(), FFprobeJAXB700.getNonNull(s.getRefs()), s.getSampleFmt(), FFprobeJAXB700.getNonNull(s.getSampleRate()), FFprobeJAXB700.getNonNull(s.getChannels()), s.getChannelLayout(), FFprobeJAXB700.getNonNull(s.getBitsPerSample()), FFprobeJAXB700.getNonNull(s.getInitialPadding()), s.getId(), s.getRFrameRate(), s.getAvgFrameRate(), s.getTimeBase(), FFprobeJAXB700.getNonNull(s.getStartPts()), FFprobeJAXB700.getNonNull(s.getStartTime()), FFprobeJAXB700.getNonNull(s.getDurationTs()), FFprobeJAXB700.getNonNull(s.getDuration()), FFprobeJAXB700.getNonNull(s.getBitRate()), FFprobeJAXB700.getNonNull(s.getMaxBitRate()), FFprobeJAXB700.getNonNull(s.getBitsPerRawSample()), FFprobeJAXB700.getNonNull(s.getNbFrames()), FFprobeJAXB700.getNonNull(s.getNbReadFrames()), FFprobeJAXB700.getNonNull(s.getNbReadPackets()))).toList();
    }

    @Override
    public List<FFProbeProgram> getPrograms() {
        return FFprobeJAXB700.getSubList(this.ffprobe.getPrograms(), ProgramType.class).map(p -> new FFProbeProgram(FFprobeJAXB700.getTags(p.getTags()), FFprobeJAXB700.getStreams(p.getStreams()), p.getProgramId(), p.getProgramNum(), p.getNbStreams(), p.getPmtPid(), p.getPcrPid())).toList();
    }

    @Override
    public List<FFProbeStream> getStreams() {
        return FFprobeJAXB700.getStreams(this.ffprobe.getStreams());
    }

    @Override
    public List<FFProbePixelFormat> getPixelFormats() {
        return FFprobeJAXB700.getSubList(this.ffprobe.getPixelFormats(), PixelFormatType.class).map(pf -> {
            PixelFormatFlagsType flags = Optional.ofNullable(pf.getFlags()).orElse(new PixelFormatFlagsType());
            List<Integer> bitDepthByComponent = FFprobeJAXB700.getSubList(pf.getComponents(), PixelFormatComponentType.class).sorted((l, r) -> Integer.compare(l.getIndex(), r.getIndex())).map(PixelFormatComponentType::getBitDepth).toList();
            return new FFProbePixelFormat(pf.getName(), pf.getNbComponents(), FFprobeJAXB700.getNonNull(pf.getLog2ChromaW()), FFprobeJAXB700.getNonNull(pf.getLog2ChromaH()), FFprobeJAXB700.getNonNull(pf.getBitsPerPixel()), FFprobeJAXB700.getNonNull(flags.getBigEndian()) == 1, FFprobeJAXB700.getNonNull(flags.getPalette()) == 1, FFprobeJAXB700.getNonNull(flags.getBitstream()) == 1, FFprobeJAXB700.getNonNull(flags.getHwaccel()) == 1, FFprobeJAXB700.getNonNull(flags.getPlanar()) == 1, FFprobeJAXB700.getNonNull(flags.getRgb()) == 1, FFprobeJAXB700.getNonNull(flags.getAlpha()) == 1, bitDepthByComponent);
        }).toList();
    }
}

