/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.util.List;
import java.util.Optional;
import org.ffmpeg.ffprobe436.ChapterType;
import org.ffmpeg.ffprobe436.FfprobeType;
import org.ffmpeg.ffprobe436.LibraryVersionType;
import org.ffmpeg.ffprobe436.PacketSideDataType;
import org.ffmpeg.ffprobe436.PixelFormatComponentType;
import org.ffmpeg.ffprobe436.PixelFormatFlagsType;
import org.ffmpeg.ffprobe436.PixelFormatType;
import org.ffmpeg.ffprobe436.ProgramType;
import org.ffmpeg.ffprobe436.StreamType;
import org.ffmpeg.ffprobe436.StreamsType;
import org.ffmpeg.ffprobe436.TagType;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.ffprobejaxb.data.FFProbeChapter;
import tv.hd3g.ffprobejaxb.data.FFProbeError;
import tv.hd3g.ffprobejaxb.data.FFProbeFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeKeyValue;
import tv.hd3g.ffprobejaxb.data.FFProbeLibraryVersion;
import tv.hd3g.ffprobejaxb.data.FFProbePacketSideData;
import tv.hd3g.ffprobejaxb.data.FFProbePixelFormat;
import tv.hd3g.ffprobejaxb.data.FFProbeProgram;
import tv.hd3g.ffprobejaxb.data.FFProbeProgramVersion;
import tv.hd3g.ffprobejaxb.data.FFProbeStream;
import tv.hd3g.ffprobejaxb.data.FFProbeStreamDisposition;

public class FFprobeJAXB436
extends FFprobeJAXB {
    private FfprobeType ffprobe;

    protected FFprobeJAXB436(String xmlContent) {
        super(xmlContent);
    }

    @Override
    protected void setJAXB(Object rawJAXB) {
        this.ffprobe = (FfprobeType)rawJAXB;
    }

    @Override
    public String getXSDVersionReference() {
        String pname = this.ffprobe.getClass().getPackageName();
        return pname.substring(pname.lastIndexOf(".") + 1);
    }

    @Override
    public List<FFProbeLibraryVersion> getLibraryVersions() {
        return FFprobeJAXB436.getSubList(this.ffprobe.getLibraryVersions(), LibraryVersionType.class).map(f -> new FFProbeLibraryVersion(f.getName(), f.getMajor(), f.getMinor(), f.getMicro(), f.getVersion(), f.getIdent())).toList();
    }

    @Override
    public Optional<FFProbeProgramVersion> getProgramVersion() {
        return Optional.ofNullable(this.ffprobe.getProgramVersion()).map(p -> new FFProbeProgramVersion(p.getVersion(), p.getCopyright(), p.getBuildDate(), p.getBuildTime(), p.getCompilerIdent(), p.getConfiguration()));
    }

    @Override
    public Optional<FFProbeError> getError() {
        return Optional.ofNullable(this.ffprobe.getError()).map(e -> new FFProbeError(e.getCode(), e.getString()));
    }

    private static List<FFProbeKeyValue> getTags(List<TagType> tagList) {
        return tagList.stream().map(t -> new FFProbeKeyValue(t.getKey(), t.getValue())).toList();
    }

    @Override
    public Optional<FFProbeFormat> getFormat() {
        return Optional.ofNullable(this.ffprobe.getFormat()).map(f -> new FFProbeFormat(FFprobeJAXB436.getTags(f.getTag()), f.getFilename(), f.getNbStreams(), f.getNbPrograms(), f.getFormatName(), f.getFormatLongName(), FFprobeJAXB436.getNonNull(f.getStartTime()), FFprobeJAXB436.getNonNull(f.getDuration()), FFprobeJAXB436.getNonNull(f.getSize()), FFprobeJAXB436.getNonNull(f.getBitRate()), FFprobeJAXB436.getNonNull(f.getProbeScore())));
    }

    @Override
    public List<FFProbeChapter> getChapters() {
        return FFprobeJAXB436.getSubList(this.ffprobe.getChapters(), ChapterType.class).map(c -> new FFProbeChapter(FFprobeJAXB436.getTags(c.getTag()), c.getId(), c.getTimeBase(), c.getStart(), c.getStartTime().floatValue(), c.getEnd(), c.getEndTime())).toList();
    }

    private static FFProbeStreamDisposition getDispositions(StreamType s) {
        return Optional.ofNullable(s.getDisposition()).map(d -> new FFProbeStreamDisposition(d.getDefault() == 1, d.getDub() == 1, d.getOriginal() == 1, d.getComment() == 1, d.getLyrics() == 1, d.getKaraoke() == 1, d.getForced() == 1, d.getHearingImpaired() == 1, d.getVisualImpaired() == 1, d.getCleanEffects() == 1, d.getAttachedPic() == 1, d.getTimedThumbnails() == 1, false, false, false, false, false, false)).orElseGet(() -> FFProbeStreamDisposition.getByNames(new String[0]));
    }

    private static List<FFProbePacketSideData> getSideDataList(StreamType s) {
        return FFprobeJAXB436.getSubList(s.getSideDataList(), PacketSideDataType.class).map(sdl -> new FFProbePacketSideData(List.of(), sdl.getSideDataType(), FFprobeJAXB436.getNonNull(sdl.getSideDataSize()))).toList();
    }

    private static List<FFProbeStream> getStreams(StreamsType streamsType) {
        return FFprobeJAXB436.getSubList(streamsType, StreamType.class).map(s -> new FFProbeStream(FFprobeJAXB436.getDispositions(s), FFprobeJAXB436.getTags(s.getTag()), FFprobeJAXB436.getSideDataList(s), s.getIndex(), s.getCodecName(), s.getCodecLongName(), s.getProfile(), s.getCodecType(), s.getCodecTag(), s.getCodecTagString(), s.getExtradata(), 0, s.getExtradataHash(), FFprobeJAXB436.getNonNull(s.getWidth()), FFprobeJAXB436.getNonNull(s.getHeight()), FFprobeJAXB436.getNonNull(s.getCodedWidth()), FFprobeJAXB436.getNonNull(s.getCodedHeight()), FFprobeJAXB436.getNonNull(s.isClosedCaptions()), false, s.getHasBFrames() != null && s.getHasBFrames() > 0, s.getSampleAspectRatio(), s.getDisplayAspectRatio(), s.getPixFmt(), FFprobeJAXB436.getNonNull(s.getLevel()), s.getColorRange(), s.getColorSpace(), s.getColorTransfer(), s.getColorPrimaries(), s.getChromaLocation(), s.getFieldOrder(), FFprobeJAXB436.getNonNull(s.getRefs()), s.getSampleFmt(), FFprobeJAXB436.getNonNull(s.getSampleRate()), FFprobeJAXB436.getNonNull(s.getChannels()), s.getChannelLayout(), FFprobeJAXB436.getNonNull(s.getBitsPerSample()), 0, s.getId(), s.getRFrameRate(), s.getAvgFrameRate(), s.getTimeBase(), FFprobeJAXB436.getNonNull(s.getStartPts()), FFprobeJAXB436.getNonNull(s.getStartTime()), FFprobeJAXB436.getNonNull(s.getDurationTs()), FFprobeJAXB436.getNonNull(s.getDuration()), FFprobeJAXB436.getNonNull(s.getBitRate()), FFprobeJAXB436.getNonNull(s.getMaxBitRate()), FFprobeJAXB436.getNonNull(s.getBitsPerRawSample()), FFprobeJAXB436.getNonNull(s.getNbFrames()), FFprobeJAXB436.getNonNull(s.getNbReadFrames()), FFprobeJAXB436.getNonNull(s.getNbReadPackets()))).toList();
    }

    @Override
    public List<FFProbeProgram> getPrograms() {
        return FFprobeJAXB436.getSubList(this.ffprobe.getPrograms(), ProgramType.class).map(p -> new FFProbeProgram(FFprobeJAXB436.getTags(p.getTag()), FFprobeJAXB436.getStreams(p.getStreams()), p.getProgramId(), p.getProgramNum(), p.getNbStreams(), p.getPmtPid(), p.getPcrPid())).toList();
    }

    @Override
    public List<FFProbeStream> getStreams() {
        return FFprobeJAXB436.getStreams(this.ffprobe.getStreams());
    }

    @Override
    public List<FFProbePixelFormat> getPixelFormats() {
        return FFprobeJAXB436.getSubList(this.ffprobe.getPixelFormats(), PixelFormatType.class).map(pf -> {
            PixelFormatFlagsType flags = Optional.ofNullable(pf.getFlags()).orElse(new PixelFormatFlagsType());
            List<Integer> bitDepthByComponent = FFprobeJAXB436.getSubList(pf.getComponents(), PixelFormatComponentType.class).sorted((l, r) -> Integer.compare(l.getIndex(), r.getIndex())).map(PixelFormatComponentType::getBitDepth).toList();
            return new FFProbePixelFormat(pf.getName(), pf.getNbComponents(), FFprobeJAXB436.getNonNull(pf.getLog2ChromaW()), FFprobeJAXB436.getNonNull(pf.getLog2ChromaH()), FFprobeJAXB436.getNonNull(pf.getBitsPerPixel()), FFprobeJAXB436.getNonNull(flags.getBigEndian()) == 1, FFprobeJAXB436.getNonNull(flags.getPalette()) == 1, FFprobeJAXB436.getNonNull(flags.getBitstream()) == 1, FFprobeJAXB436.getNonNull(flags.getHwaccel()) == 1, FFprobeJAXB436.getNonNull(flags.getPlanar()) == 1, FFprobeJAXB436.getNonNull(flags.getRgb()) == 1, FFprobeJAXB436.getNonNull(flags.getAlpha()) == 1, bitDepthByComponent);
        }).toList();
    }
}

