/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import tv.hd3g.ffprobejaxb.FFprobeReference;
import tv.hd3g.ffprobejaxb.FFprobeXSDVersion;
import tv.hd3g.ffprobejaxb.MediaSummary;
import tv.hd3g.ffprobejaxb.UnmarshallerTools;

public abstract class FFprobeJAXB
implements FFprobeReference {
    private static final Logger log = LoggerFactory.getLogger(FFprobeJAXB.class);
    private static final String LOADED_XML = "Loaded XML: {}";
    private final String xmlContent;

    protected FFprobeJAXB(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    @Override
    public String getXmlContent() {
        return this.xmlContent;
    }

    protected abstract void setJAXB(Object var1);

    public static FFprobeJAXB load(final String xmlContent) {
        Node document;
        try {
            document = UnmarshallerTools.parseXMLDocument(xmlContent, new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    log.debug(FFprobeJAXB.LOADED_XML, (Object)xmlContent);
                    log.warn("XML parser warning", (Throwable)exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    log.debug(FFprobeJAXB.LOADED_XML, (Object)xmlContent);
                    log.error("XML parser fatal error", (Throwable)exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    log.debug(FFprobeJAXB.LOADED_XML, (Object)xmlContent);
                    log.error("XML parser error", (Throwable)exception);
                }
            });
        }
        catch (ParserConfigurationException | SAXException e2) {
            throw new UncheckedIOException(new IOException("Can't load XML content", e2));
        }
        EnumMap eventsByXSDVersion = new EnumMap(FFprobeXSDVersion.class);
        JAXBException lastJAXBException = null;
        FFprobeJAXB jaxbReference = null;
        for (FFprobeXSDVersion xsdVersion : FFprobeXSDVersion.values()) {
            ConcurrentLinkedQueue events = new ConcurrentLinkedQueue();
            try {
                log.debug("Try to load JAXB {}", (Object)xsdVersion.name());
                Object ffRef = UnmarshallerTools.unmarshal(xsdVersion.createInstance(), document, events::add, xsdVersion.getClassJAXB());
                List lastEvents = events.stream().toList();
                eventsByXSDVersion.put(xsdVersion, lastEvents);
                if (!events.isEmpty()) continue;
                jaxbReference = xsdVersion.make(xmlContent, ffRef);
            }
            catch (JAXBException e3) {
                log.debug("Can't load JAXB", (Throwable)e3);
                lastJAXBException = e3;
            }
        }
        if (jaxbReference == null) {
            if (lastJAXBException != null) {
                throw new UncheckedIOException(new IOException(lastJAXBException));
            }
            eventsByXSDVersion.getOrDefault((Object)FFprobeXSDVersion.values()[0], List.of()).forEach(e -> {
                ValidationEventLocator locator = e.getLocator();
                log.error("JAXB {} says: {} [s{}] at line {}, column {} offset {} node: {}, object {}", new Object[]{FFprobeXSDVersion.values()[0].name(), e.getMessage(), e.getSeverity(), locator.getLineNumber(), locator.getColumnNumber(), locator.getOffset(), locator.getNode(), locator.getObject(), e.getLinkedException()});
            });
            throw new IllegalArgumentException("Can't properly load ffprobe JAXB. You should update ffprobe.xsd ref and/or check XML document");
        }
        return jaxbReference;
    }

    protected static <T> Stream<T> getSubList(Object jaxbSubListClass, Class<T> outputFormat) {
        if (jaxbSubListClass == null) {
            return Stream.empty();
        }
        Method getterMethod = Stream.of(jaxbSubListClass.getClass().getMethods()).filter(m -> m.getName().startsWith("get")).filter(m -> m.getReturnType().isAssignableFrom(List.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't found a List getter"));
        try {
            Object raw = getterMethod.invoke(jaxbSubListClass, new Object[0]);
            if (raw == null) {
                return Stream.empty();
            }
            return ((List)raw).stream().filter(Objects::nonNull).map(outputFormat::cast);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MediaSummary getMediaSummary() {
        return MediaSummary.create(this);
    }

    public String toString() {
        return this.getMediaSummary().toString();
    }

    static boolean getNonNull(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    static int getNonNull(Integer value) {
        if (value == null) {
            return 0;
        }
        return value;
    }

    static long getNonNull(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }

    static float getNonNull(Float value) {
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }
}

