/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ffmpeg.ffprobe.FormatType;
import org.ffmpeg.ffprobe.StreamDispositionType;
import org.ffmpeg.ffprobe.StreamType;
import org.ffmpeg.ffprobe.TagType;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;

public record MediaSummary(String format, List<String> streams) {
    private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);

    static MediaSummary create(FFprobeJAXB source) {
        FormatType format = source.getFormat();
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(format.getFormatLongName());
        entries.add(MediaSummary.computeDuration(format));
        if (format.getSize() <= 0x100000L) {
            entries.add(format.getSize() + " bytes");
        } else {
            entries.add(format.getSize() / 1024L / 1024L + " MB");
        }
        if (format.getNbPrograms() > 0) {
            entries.add(format.getNbPrograms() + " program(s)");
        }
        if (!source.getChapters().isEmpty()) {
            entries.add(source.getChapters().size() + " chapter(s)");
        }
        if (!source.getVideoStreams().anyMatch(f -> f.getBitRate() != null) && !source.getAudiosStreams().anyMatch(f -> f.getBitRate() != null)) {
            Optional.ofNullable(format.getBitRate()).ifPresent(b -> {
                double bitrateKbps = (double)b.longValue() / 1000.0;
                if (bitrateKbps < 10000.0) {
                    entries.add(Math.round(bitrateKbps) + " kbps");
                } else {
                    entries.add(Math.round(bitrateKbps / 1000.0) + " Mbps");
                }
            });
        }
        Stream<String> videos = source.getVideoStreams().map(MediaSummary::getVideoSummary);
        Stream<String> audios = source.getAudiosStreams().map(MediaSummary::getAudioSummary);
        Stream<String> others = MediaSummary.computeOther(source);
        return new MediaSummary(entries.stream().collect(Collectors.joining(", ")), Stream.concat(videos, Stream.concat(audios, others)).toList());
    }

    static Optional<String> getValue(String value) {
        return Optional.ofNullable(value).flatMap(v -> {
            if (v.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable(v);
        });
    }

    private static Stream<String> optDisposition(int value, String label) {
        if (value == 1) {
            return Stream.of(label);
        }
        return Stream.empty();
    }

    public static Stream<String> resumeDispositions(StreamDispositionType s) {
        if (s == null) {
            return Stream.of(new String[0]);
        }
        return Stream.of(MediaSummary.optDisposition(s.getDefault(), "default stream"), MediaSummary.optDisposition(s.getAttachedPic(), "attached picture"), MediaSummary.optDisposition(s.getTimedThumbnails(), "timed thumbnails"), MediaSummary.optDisposition(s.getStillImage(), "still image"), MediaSummary.optDisposition(s.getHearingImpaired(), "hearing impaired"), MediaSummary.optDisposition(s.getVisualImpaired(), "visual impaired"), MediaSummary.optDisposition(s.getDub(), "dub"), MediaSummary.optDisposition(s.getOriginal(), "original"), MediaSummary.optDisposition(s.getComment(), "comment"), MediaSummary.optDisposition(s.getLyrics(), "lyrics"), MediaSummary.optDisposition(s.getKaraoke(), "karaoke"), MediaSummary.optDisposition(s.getForced(), "forced"), MediaSummary.optDisposition(s.getCleanEffects(), "clean effects"), MediaSummary.optDisposition(s.getCaptions(), "captions"), MediaSummary.optDisposition(s.getDescriptions(), "descriptions"), MediaSummary.optDisposition(s.getMetadata(), "metadata"), MediaSummary.optDisposition(s.getDependent(), "dependent")).flatMap(Function.identity());
    }

    static String getAudioSummary(StreamType s) {
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(s.getCodecType() + ": " + s.getCodecName());
        MediaSummary.getValue(s.getProfile()).ifPresent(entries::add);
        MediaSummary.getValue(s.getSampleFmt()).flatMap(f -> {
            if (f.equals("fltp") || s.getCodecName().contains((CharSequence)f)) {
                return Optional.empty();
            }
            return Optional.ofNullable(f);
        }).ifPresent(entries::add);
        if (s.getChannels() > 2) {
            if (s.getChannelLayout() != null) {
                entries.add(s.getChannelLayout() + " (" + s.getChannels() + " channels)");
            } else {
                entries.add(s.getChannels() + " channels");
            }
        } else if (s.getChannelLayout() != null) {
            entries.add(s.getChannelLayout());
        } else if (s.getChannels() == 2) {
            entries.add("2 channels");
        } else {
            entries.add("mono");
        }
        Optional.ofNullable(s.getSampleRate()).ifPresent(sr -> entries.add("@ " + sr + " Hz"));
        Optional.ofNullable(s.getBitRate()).ifPresent(b -> entries.add("[" + b / 1000 + " kbps]"));
        String dispositions = MediaSummary.resumeDispositions(s.getDisposition()).collect(Collectors.joining(", "));
        if (!dispositions.isEmpty()) {
            entries.add(dispositions);
        }
        return entries.stream().collect(Collectors.joining(" "));
    }

    static String getVideoSummary(StreamType s) {
        String dispositions;
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(s.getCodecType() + ": " + s.getCodecName());
        if (s.getWidth() != null && s.getHeight() != null) {
            entries.add(s.getWidth() + "\u00d7" + s.getHeight());
        }
        Optional<String> profile = MediaSummary.getValue(s.getProfile()).filter(p -> !p.equals("0"));
        Integer level = Optional.ofNullable(s.getLevel()).orElse(0);
        if (profile.isPresent()) {
            if (level > 0) {
                entries.add(profile.get() + "/" + MediaSummary.getLevelTag(s.getCodecName(), level));
            } else {
                entries.add(profile.get());
            }
        } else if (level > 0) {
            entries.add(MediaSummary.getLevelTag(s.getCodecName(), level));
        }
        if (s.getHasBFrames() != null && s.getHasBFrames() > 0) {
            entries.add("with B frames");
        }
        String frameRate = MediaSummary.getValue(s.getAvgFrameRate()).map(b -> {
            int pos = b.indexOf("/");
            if (pos == -1) {
                return b;
            }
            Double l = Double.valueOf(b.substring(0, pos));
            Double r = Double.valueOf(b.substring(pos + 1));
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(symbols);
            df.setMaximumFractionDigits(3);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(false);
            return df.format(l / r);
        }).orElse("?");
        entries.add("@ " + frameRate + " fps");
        Optional.ofNullable(s.getBitRate()).ifPresent(b -> {
            double bitrateKbps = (double)b.intValue() / 1000.0;
            if (bitrateKbps < 10000.0) {
                entries.add("[" + Math.round(bitrateKbps) + " kbps]");
            } else {
                entries.add("[" + Math.round(bitrateKbps / 1000.0) + " Mbps]");
            }
        });
        String cpf = MediaSummary.computePixelsFormat(s);
        if (!cpf.isEmpty()) {
            entries.add(cpf);
        }
        if (s.getNbFrames() != null && s.getNbFrames() > 0) {
            entries.add("(" + s.getNbFrames() + " frms)");
        }
        if (!(dispositions = MediaSummary.resumeDispositions(s.getDisposition()).collect(Collectors.joining(", "))).isEmpty()) {
            entries.add(dispositions);
        }
        return entries.stream().collect(Collectors.joining(" "));
    }

    public static String getLevelTag(String videoCodec, int rawLevel) {
        return switch (videoCodec) {
            case "mpeg1video", "mpeg2video", "mpegvideo" -> {
                switch (rawLevel) {
                    case 4: {
                        yield "High";
                    }
                    case 6: {
                        yield "High 1440";
                    }
                    case 8: {
                        yield "Main";
                    }
                    case 10: {
                        yield "Low";
                    }
                }
                yield "L" + rawLevel;
            }
            case "h264", "avc" -> {
                switch (rawLevel) {
                    case 10: {
                        yield "1";
                    }
                    case 9: {
                        yield "1b";
                    }
                    case 11: {
                        yield "1.1";
                    }
                    case 12: {
                        yield "1.2";
                    }
                    case 13: {
                        yield "1.3";
                    }
                    case 20: {
                        yield "2";
                    }
                    case 21: {
                        yield "2.1";
                    }
                    case 22: {
                        yield "2.2";
                    }
                    case 30: {
                        yield "3";
                    }
                    case 31: {
                        yield "3.1";
                    }
                    case 32: {
                        yield "3.2";
                    }
                    case 40: {
                        yield "4";
                    }
                    case 41: {
                        yield "4.1";
                    }
                    case 42: {
                        yield "4.2";
                    }
                    case 50: {
                        yield "5";
                    }
                    case 51: {
                        yield "5.1";
                    }
                    case 52: {
                        yield "5.2";
                    }
                    case 60: {
                        yield "6";
                    }
                    case 61: {
                        yield "6.1";
                    }
                    case 62: {
                        yield "6.2";
                    }
                }
                yield "L" + rawLevel;
            }
            case "hevc", "h265" -> {
                switch (rawLevel) {
                    case 30: {
                        yield "1";
                    }
                    case 60: {
                        yield "2";
                    }
                    case 63: {
                        yield "2.1";
                    }
                    case 90: {
                        yield "3";
                    }
                    case 93: {
                        yield "3.1";
                    }
                    case 120: {
                        yield "4";
                    }
                    case 123: {
                        yield "4.1";
                    }
                    case 150: {
                        yield "5";
                    }
                    case 153: {
                        yield "5.1";
                    }
                    case 156: {
                        yield "5.2";
                    }
                    case 180: {
                        yield "6";
                    }
                    case 183: {
                        yield "6.1";
                    }
                    case 186: {
                        yield "6.2";
                    }
                    case 255: {
                        yield "8.5";
                    }
                }
                yield "L" + rawLevel;
            }
            case "av1" -> {
                switch (rawLevel) {
                    case 20: {
                        yield "2.0";
                    }
                    case 21: {
                        yield "2.1";
                    }
                    case 22: {
                        yield "2.2";
                    }
                    case 23: {
                        yield "2.3";
                    }
                    case 30: {
                        yield "3.0";
                    }
                    case 31: {
                        yield "3.1";
                    }
                    case 32: {
                        yield "3.2";
                    }
                    case 33: {
                        yield "3.3";
                    }
                    case 40: {
                        yield "4.0";
                    }
                    case 41: {
                        yield "4.1";
                    }
                    case 42: {
                        yield "4.2";
                    }
                    case 43: {
                        yield "4.3";
                    }
                    case 50: {
                        yield "5.0";
                    }
                    case 51: {
                        yield "5.1";
                    }
                    case 52: {
                        yield "5.2";
                    }
                    case 53: {
                        yield "5.3";
                    }
                    case 60: {
                        yield "6.0";
                    }
                    case 61: {
                        yield "6.1";
                    }
                    case 62: {
                        yield "6.2";
                    }
                    case 63: {
                        yield "6.3";
                    }
                    case 70: {
                        yield "7.0";
                    }
                    case 71: {
                        yield "7.1";
                    }
                    case 72: {
                        yield "7.2";
                    }
                    case 73: {
                        yield "7.3";
                    }
                }
                yield "L" + rawLevel;
            }
            default -> "L" + rawLevel;
        };
    }

    static String computePixelsFormat(StreamType s) {
        ArrayList entries = new ArrayList();
        MediaSummary.getValue(s.getPixFmt()).ifPresent(entries::add);
        MediaSummary.getValue(s.getColorRange()).map(v -> "colRange:" + v.toUpperCase()).ifPresent(entries::add);
        Optional<String> oColorSpace = MediaSummary.getValue(s.getColorSpace());
        Optional<String> oColorTransfer = MediaSummary.getValue(s.getColorTransfer());
        Optional<String> oColorPrimaries = MediaSummary.getValue(s.getColorPrimaries());
        if (oColorSpace.isPresent() && oColorSpace.equals(oColorTransfer) && oColorSpace.equals(oColorPrimaries)) {
            oColorSpace.map(String::toUpperCase).ifPresent(entries::add);
        } else {
            Stream.concat(oColorSpace.map(v -> "colSpace:" + v.toUpperCase()).stream(), Stream.concat(oColorTransfer.map(v -> "colTransfer:" + v.toUpperCase()).stream(), oColorPrimaries.map(v -> "colPrimaries:" + v.toUpperCase()).stream())).forEach(entries::add);
        }
        return entries.stream().collect(Collectors.joining("/"));
    }

    static void addZeros(int value, StringBuilder sbTime) {
        if (value < 10) {
            sbTime.append("0");
        }
        sbTime.append(value);
    }

    public static String computeDuration(FormatType format) {
        Duration duration = Duration.ofMillis(Math.round(format.getDuration().floatValue() * 1000.0f));
        StringBuilder sbTime = new StringBuilder();
        MediaSummary.addZeros(duration.toHoursPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toMinutesPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toSecondsPart(), sbTime);
        return sbTime.toString();
    }

    private static Stream<String> computeOther(FFprobeJAXB source) {
        return source.getStreams().stream().filter(Predicate.not(FFprobeJAXB.filterAudioStream)).filter(Predicate.not(FFprobeJAXB.filterVideoStream)).map(v -> {
            String name = MediaSummary.getValue(v.getCodecName()).or(() -> MediaSummary.getValue(v.getCodecTagString())).orElse("");
            String handler = v.getTag().stream().filter(t -> "handler_name".equals(t.getKey())).findFirst().map(TagType::getValue).map(t -> " (" + t + ")").orElse("");
            String tc = v.getTag().stream().filter(t -> "timecode".equals(t.getKey())).findFirst().map(TagType::getValue).map(t -> " " + t).orElse("");
            return v.getCodecType() + ": " + name + handler + tc;
        });
    }

    @Override
    public String toString() {
        ToIntFunction<String> computeHeaders = v -> {
            if (v.contains("video: ")) {
                return 0;
            }
            if (v.contains("audio: ")) {
                return 1;
            }
            return 2;
        };
        ToIntFunction<String> computeBitrate = v -> {
            int from = v.indexOf("[");
            int toK = v.indexOf("kbps]");
            int toM = v.indexOf("Mbps]");
            if (from == -1 || toK == -1 && toM == -1) {
                return 0;
            }
            if (toK > -1) {
                return Integer.valueOf(v.substring(from + 1, toK - 1));
            }
            return Integer.valueOf(v.substring(from + 1, toM - 1)) * 1000;
        };
        String streamsCollected = this.streams.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().map(entry -> {
            if ((Long)entry.getValue() > 1L) {
                return entry.getValue() + "\u00d7 " + (String)entry.getKey();
            }
            return (String)entry.getKey();
        }).sorted((l, r) -> {
            int rV;
            int lV = computeHeaders.applyAsInt((String)l);
            if (lV == (rV = computeHeaders.applyAsInt((String)r))) {
                return Integer.compare(computeBitrate.applyAsInt((String)r), computeBitrate.applyAsInt((String)l));
            }
            return Integer.compare(lV, rV);
        }).collect(Collectors.joining(", "));
        return this.format + ", " + streamsCollected;
    }
}

