/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ffmpeg.ffprobe.FormatType;
import org.ffmpeg.ffprobe.StreamDispositionType;
import org.ffmpeg.ffprobe.StreamType;
import org.ffmpeg.ffprobe.TagType;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;

public record MediaSummary(String format, List<String> streams) {
    private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);

    static MediaSummary create(FFprobeJAXB source) {
        FormatType format = source.getFormat();
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(format.getFormatLongName());
        entries.add(MediaSummary.computeDuration(format));
        entries.add(format.getSize() / 1024L / 1024L + " MB");
        if (format.getNbPrograms() > 0) {
            entries.add(format.getNbPrograms() + " program(s)");
        }
        if (!source.getChapters().isEmpty()) {
            entries.add(source.getChapters().size() + " chapter(s)");
        }
        if (!source.getVideoStreams().anyMatch(f -> f.getBitRate() != null) && !source.getAudiosStreams().anyMatch(f -> f.getBitRate() != null)) {
            Optional.ofNullable(format.getBitRate()).ifPresent(b -> {
                double bitrateKbps = (double)b.longValue() / 1000.0;
                if (bitrateKbps < 10000.0) {
                    entries.add(Math.round(bitrateKbps) + " kbps");
                } else {
                    entries.add(Math.round(bitrateKbps / 1000.0) + " Mbps");
                }
            });
        }
        Stream<String> videos = source.getVideoStreams().map(MediaSummary::getVideoSummary);
        Stream<String> audios = source.getAudiosStreams().map(MediaSummary::getAudioSummary);
        Stream<String> others = MediaSummary.computeOther(source);
        return new MediaSummary(entries.stream().collect(Collectors.joining(", ")), Stream.concat(videos, Stream.concat(audios, others)).toList());
    }

    static Optional<String> getValue(String value) {
        return Optional.ofNullable(value).flatMap(v -> {
            if (v.isEmpty()) {
                return Optional.empty();
            }
            return Optional.ofNullable(v);
        });
    }

    static void addDisposition(StreamDispositionType s, List<String> entries) {
        if (s == null || s.getDefault() == 1 && s.getAttachedPic() == 0) {
            return;
        }
        if (s.getDefault() != 1) {
            entries.add("set not by default");
        }
        if (s.getAttachedPic() != 0) {
            entries.add("attached picture");
        }
    }

    static String getAudioSummary(StreamType s) {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(s.getCodecType() + ": " + s.getCodecName());
        MediaSummary.getValue(s.getProfile()).ifPresent(entries::add);
        MediaSummary.getValue(s.getSampleFmt()).flatMap(f -> {
            if (f.equals("fltp") || s.getCodecName().contains((CharSequence)f)) {
                return Optional.empty();
            }
            return Optional.ofNullable(f);
        }).ifPresent(entries::add);
        if (s.getChannels() > 2) {
            entries.add(s.getChannelLayout() + " (" + s.getChannels() + " channels)");
        } else {
            entries.add(s.getChannelLayout());
        }
        Optional.ofNullable(s.getSampleRate()).ifPresent(sr -> entries.add("@ " + sr + " Hz"));
        Optional.ofNullable(s.getBitRate()).ifPresent(b -> entries.add("[" + b / 1000 + " kbps]"));
        MediaSummary.addDisposition(s.getDisposition(), entries);
        return entries.stream().collect(Collectors.joining(" "));
    }

    static String getVideoSummary(StreamType s) {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(s.getCodecType() + ": " + s.getCodecName());
        if (s.getWidth() != null && s.getHeight() != null) {
            entries.add(s.getWidth() + "\u00d7" + s.getHeight());
        }
        Optional<String> profile = MediaSummary.getValue(s.getProfile());
        Integer level = Optional.ofNullable(s.getLevel()).orElse(0);
        if (profile.isPresent()) {
            if (level > 0) {
                entries.add(profile.get() + "/" + level);
            } else {
                entries.add(profile.get());
            }
        } else if (level > 0) {
            entries.add("Level: " + level);
        }
        if (s.getHasBFrames() != null && s.getHasBFrames() > 0) {
            entries.add("Has B frames");
        }
        String frameRate = MediaSummary.getValue(s.getAvgFrameRate()).map(b -> {
            int pos = b.indexOf("/");
            if (pos == -1) {
                return b;
            }
            Double l = Double.valueOf(b.substring(0, pos));
            Double r = Double.valueOf(b.substring(pos + 1));
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(symbols);
            df.setMaximumFractionDigits(3);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(false);
            return df.format(l / r);
        }).orElse("?");
        entries.add("@ " + frameRate + " fps");
        Optional.ofNullable(s.getBitRate()).ifPresent(b -> {
            double bitrateKbps = (double)b.intValue() / 1000.0;
            if (bitrateKbps < 10000.0) {
                entries.add("[" + Math.round(bitrateKbps) + " kbps]");
            } else {
                entries.add("[" + Math.round(bitrateKbps / 1000.0) + " Mbps]");
            }
        });
        String cpf = MediaSummary.computePixelsFormat(s);
        if (!cpf.isEmpty()) {
            entries.add(cpf);
        }
        if (s.getNbFrames() != null && s.getNbFrames() > 0) {
            entries.add("(" + s.getNbFrames() + " frms)");
        }
        MediaSummary.addDisposition(s.getDisposition(), entries);
        return entries.stream().collect(Collectors.joining(" "));
    }

    static String computePixelsFormat(StreamType s) {
        ArrayList entries = new ArrayList();
        MediaSummary.getValue(s.getPixFmt()).ifPresent(entries::add);
        MediaSummary.getValue(s.getColorRange()).map(v -> "rng:" + v.toUpperCase()).ifPresent(entries::add);
        Stream.concat(MediaSummary.getValue(s.getColorSpace()).map(v -> "spce:" + v.toUpperCase()).stream(), Stream.concat(MediaSummary.getValue(s.getColorTransfer()).map(v -> "tsfer:" + v.toUpperCase()).stream(), MediaSummary.getValue(s.getColorPrimaries()).map(v -> "prim:" + v.toUpperCase()).stream())).distinct().forEach(entries::add);
        return entries.stream().collect(Collectors.joining("/"));
    }

    static void addZeros(int value, StringBuilder sbTime) {
        if (value < 10) {
            sbTime.append("0");
        }
        sbTime.append(value);
    }

    static String computeDuration(FormatType format) {
        Duration duration = Duration.ofMillis(Math.round(format.getDuration().floatValue() * 1000.0f));
        StringBuilder sbTime = new StringBuilder();
        MediaSummary.addZeros(duration.toHoursPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toMinutesPart(), sbTime);
        sbTime.append(":");
        MediaSummary.addZeros(duration.toSecondsPart(), sbTime);
        return sbTime.toString();
    }

    private static Stream<String> computeOther(FFprobeJAXB source) {
        return source.getStreams().stream().filter(Predicate.not(FFprobeJAXB.filterAudioStream)).filter(Predicate.not(FFprobeJAXB.filterVideoStream)).map(v -> {
            String name = MediaSummary.getValue(v.getCodecName()).or(() -> MediaSummary.getValue(v.getCodecTagString())).orElse("");
            String handler = v.getTag().stream().filter(t -> "handler_name".equals(t.getKey())).findFirst().map(TagType::getValue).map(t -> " (" + t + ")").orElse("");
            String tc = v.getTag().stream().filter(t -> "timecode".equals(t.getKey())).findFirst().map(TagType::getValue).map(t -> " " + t).orElse("");
            return v.getCodecType() + ": " + name + handler + tc;
        });
    }

    @Override
    public String toString() {
        ToIntFunction<String> computeHeaders = v -> {
            if (v.contains("video: ")) {
                return 0;
            }
            if (v.contains("audio: ")) {
                return 1;
            }
            return 2;
        };
        ToIntFunction<String> computeBitrate = v -> {
            int from = v.indexOf("[");
            int toK = v.indexOf("kbps]");
            int toM = v.indexOf("Mbps]");
            if (from == -1 || toK == -1 && toM == -1) {
                return 0;
            }
            if (toK > -1) {
                return Integer.valueOf(v.substring(from + 1, toK - 1));
            }
            return Integer.valueOf(v.substring(from + 1, toM - 1)) * 1000;
        };
        String streamsCollected = this.streams.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().map(entry -> {
            if ((Long)entry.getValue() > 1L) {
                return entry.getValue() + "\u00d7 " + (String)entry.getKey();
            }
            return (String)entry.getKey();
        }).sorted((l, r) -> {
            int rV;
            int lV = computeHeaders.applyAsInt((String)l);
            if (lV == (rV = computeHeaders.applyAsInt((String)r))) {
                return Integer.compare(computeBitrate.applyAsInt((String)r), computeBitrate.applyAsInt((String)l));
            }
            return Integer.compare(lV, rV);
        }).collect(Collectors.joining(", "));
        return this.format + ", " + streamsCollected;
    }
}

