/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.ffprobejaxb;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ffmpeg.ffprobe.ChapterType;
import org.ffmpeg.ffprobe.ChaptersType;
import org.ffmpeg.ffprobe.ErrorType;
import org.ffmpeg.ffprobe.FfprobeType;
import org.ffmpeg.ffprobe.FormatType;
import org.ffmpeg.ffprobe.FramesType;
import org.ffmpeg.ffprobe.LibraryVersionType;
import org.ffmpeg.ffprobe.LibraryVersionsType;
import org.ffmpeg.ffprobe.PacketType;
import org.ffmpeg.ffprobe.PacketsAndFramesType;
import org.ffmpeg.ffprobe.PacketsType;
import org.ffmpeg.ffprobe.PixelFormatType;
import org.ffmpeg.ffprobe.PixelFormatsType;
import org.ffmpeg.ffprobe.ProgramType;
import org.ffmpeg.ffprobe.ProgramVersionType;
import org.ffmpeg.ffprobe.ProgramsType;
import org.ffmpeg.ffprobe.StreamType;
import org.ffmpeg.ffprobe.StreamsType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FFprobeJAXB {
    public final FfprobeType probeResult;
    private final String xmlContent;
    public static final Predicate<StreamType> filterVideoStream = streamType -> streamType.getCodecType().equals("video");
    public static final Predicate<StreamType> filterAudioStream = streamType -> streamType.getCodecType().equals("audio");
    public static final Predicate<StreamType> filterDataStream = streamType -> streamType.getCodecType().equals("data");

    public FFprobeJAXB(String xmlContent, Consumer<String> onWarnLog) {
        this.xmlContent = xmlContent;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.ffmpeg.ffprobe");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler(e -> {
                ValidationEventLocator locator = e.getLocator();
                onWarnLog.accept("XML validation: " + e.getMessage() + " [s" + e.getSeverity() + "] at line " + locator.getLineNumber() + ", column " + locator.getColumnNumber() + " offset " + locator.getOffset() + " node: " + locator.getNode() + ", object " + locator.getObject());
                return true;
            });
            DocumentBuilderFactory xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            xmlDocumentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            xmlDocumentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            xmlDocumentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder xmlDocumentBuilder = xmlDocumentBuilderFactory.newDocumentBuilder();
            xmlDocumentBuilder.setErrorHandler(null);
            Document document = xmlDocumentBuilder.parse(new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)));
            this.probeResult = (FfprobeType)unmarshaller.unmarshal((Node)document, FfprobeType.class).getValue();
        }
        catch (JAXBException | ParserConfigurationException | SAXException e2) {
            throw new UncheckedIOException(new IOException("Can't load XML content", e2));
        }
        catch (IOException e1) {
            throw new UncheckedIOException(e1);
        }
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public List<ChapterType> getChapters() {
        return Optional.ofNullable(this.probeResult.getChapters()).map(ChaptersType::getChapter).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<StreamType> getStreams() {
        return Optional.ofNullable(this.probeResult.getStreams()).map(StreamsType::getStream).map(Collections::unmodifiableList).orElse(List.of());
    }

    public FormatType getFormat() {
        return this.probeResult.getFormat();
    }

    public ErrorType getError() {
        return this.probeResult.getError();
    }

    public ProgramVersionType getProgramVersion() {
        return this.probeResult.getProgramVersion();
    }

    public List<LibraryVersionType> getLibraryVersions() {
        return Optional.ofNullable(this.probeResult.getLibraryVersions()).map(LibraryVersionsType::getLibraryVersion).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<PixelFormatType> getPixelFormats() {
        return Optional.ofNullable(this.probeResult.getPixelFormats()).map(PixelFormatsType::getPixelFormat).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<PacketType> getPackets() {
        return Optional.ofNullable(this.probeResult.getPackets()).map(PacketsType::getPacket).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<Object> getFrames() {
        return Optional.ofNullable(this.probeResult.getFrames()).map(FramesType::getFrameOrSubtitle).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<Object> getPacketsAndFrames() {
        return Optional.ofNullable(this.probeResult.getPacketsAndFrames()).map(PacketsAndFramesType::getPacketOrFrameOrSubtitle).map(Collections::unmodifiableList).orElse(List.of());
    }

    public List<ProgramType> getPrograms() {
        return Optional.ofNullable(this.probeResult.getPrograms()).map(ProgramsType::getProgram).map(Collections::unmodifiableList).orElse(List.of());
    }

    public Stream<StreamType> getVideoStreams() {
        return this.getStreams().stream().filter(filterVideoStream);
    }

    public Stream<StreamType> getAudiosStreams() {
        return this.getStreams().stream().filter(filterAudioStream);
    }

    public Optional<StreamType> getFirstVideoStream() {
        return this.getVideoStreams().filter(vs -> vs.getDisposition().getAttachedPic() == 0).filter(vs -> vs.getDisposition().getTimedThumbnails() == 0).sorted((l, r) -> Integer.compare(r.getDisposition().getDefault(), l.getDisposition().getDefault())).findFirst();
    }
}

