/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.filtering.FilterArgument;
import tv.hd3g.fflauncher.filtering.parser.FilterParserChain;
import tv.hd3g.fflauncher.filtering.parser.FilterParserChars;
import tv.hd3g.fflauncher.filtering.parser.FilterParserDefinition;
import tv.hd3g.fflauncher.filtering.parser.FilterParserFilter;
import tv.hd3g.fflauncher.filtering.parser.FilterParserGraphBranch;
import tv.hd3g.fflauncher.filtering.parser.FilterParserSimpleChar;

public class FilterParser {
    private final FilterParserSimpleChar[] filterChars;

    FilterParser(String rawFilterChain) {
        this.filterChars = new FilterParserSimpleChar[rawFilterChain.length()];
        for (int pos = 0; pos < rawFilterChain.length(); ++pos) {
            this.filterChars[pos] = new FilterParserSimpleChar(rawFilterChain.charAt(pos));
        }
    }

    public static <T extends FilterParserDefinition> List<List<T>> fullParsing(String rawFilterChain, Supplier<T> filterDefSupplier) {
        return new ArrayList<List<T>>(new FilterParser(rawFilterChain).getGraphBranchs().stream().map(graphBranch -> new ArrayList(graphBranch.getRawChains().stream().map(arg_0 -> FilterParser.lambda$fullParsing$0((Supplier)filterDefSupplier, arg_0)).collect(Collectors.toUnmodifiableList()))).collect(Collectors.toUnmodifiableList()));
    }

    List<FilterParserChars> getUnescapeAndUnQuoted() {
        ArrayList<FilterParserChars> result = new ArrayList<FilterParserChars>();
        boolean inEscaped = false;
        boolean inQuoted = false;
        StringBuilder captured = new StringBuilder();
        for (int pos = 0; pos < this.filterChars.length; ++pos) {
            FilterParserSimpleChar current = this.filterChars[pos];
            if (inEscaped) {
                inEscaped = false;
                if (inQuoted) {
                    current.write(captured);
                    continue;
                }
                result.add(current.toEscapedFilterChars());
                continue;
            }
            if (current.isEscape()) {
                inEscaped = true;
                continue;
            }
            if (current.isQuoted()) {
                current.write(captured);
                if (inQuoted) {
                    result.add(new FilterParserChars(captured));
                    captured = new StringBuilder();
                }
                inQuoted = !inQuoted;
                continue;
            }
            if (inQuoted) {
                current.write(captured);
                continue;
            }
            if (current.isSpace()) continue;
            result.add(current.toFilterChars());
        }
        return Collections.unmodifiableList(result);
    }

    List<FilterParserGraphBranch> getGraphBranchs() {
        List<FilterParserChars> list = this.getUnescapeAndUnQuoted();
        ArrayList<FilterParserGraphBranch> result = new ArrayList<FilterParserGraphBranch>();
        ArrayList<FilterParserChars> chain = new ArrayList<FilterParserChars>();
        for (int pos = 0; pos < list.size(); ++pos) {
            FilterParserChars current = list.get(pos);
            if (current.isSemicolon()) {
                if (chain.isEmpty()) continue;
                result.add(new FilterParserGraphBranch(chain));
                chain = new ArrayList();
                continue;
            }
            chain.add(current);
        }
        if (!chain.isEmpty()) {
            result.add(new FilterParserGraphBranch(chain));
        }
        return Collections.unmodifiableList(result);
    }

    private static /* synthetic */ FilterParserDefinition lambda$fullParsing$0(Supplier filterDefSupplier, FilterParserChain chain) {
        FilterParserDefinition definition = (FilterParserDefinition)filterDefSupplier.get();
        definition.setSourceBlocks(new ArrayList<String>(chain.getSourceBlocks()));
        definition.setDestBlocks(new ArrayList<String>(chain.getDestBlocks()));
        FilterParserFilter filter = chain.getFilter();
        definition.setFilterName(filter.getFilterName());
        definition.setArguments(new ArrayList<FilterArgument>(filter.getFilterArguments()));
        return definition;
    }
}

