/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.filtering.FilterArgument;
import tv.hd3g.fflauncher.filtering.parser.FilterParser;
import tv.hd3g.fflauncher.filtering.parser.FilterParserDefinition;

public class Filter
implements FilterParserDefinition {
    private List<String> sourceBlocks;
    private List<String> destBlocks;
    private String filterName;
    private List<FilterArgument> arguments;

    public Filter(String rawFilter) {
        List<List<Filter>> items = FilterParser.fullParsing(rawFilter, () -> this);
        if (items.size() > 1 || items.get(0).size() > 1) {
            throw new IllegalArgumentException("This is filter chain, not a simple filter: " + rawFilter);
        }
    }

    Filter() {
    }

    public Filter(String filterName, Collection<FilterArgument> arguments) {
        this.filterName = filterName;
        this.arguments = new ArrayList<FilterArgument>(arguments);
        this.sourceBlocks = new ArrayList<String>();
        this.destBlocks = new ArrayList<String>();
    }

    public Filter(String filterName, FilterArgument ... arguments) {
        this.filterName = filterName;
        for (int pos = 0; pos < arguments.length; ++pos) {
            Objects.requireNonNull(arguments[pos], "arguments can't contain null elements: #" + pos);
        }
        this.arguments = new ArrayList<FilterArgument>(List.of(arguments));
        this.sourceBlocks = new ArrayList<String>();
        this.destBlocks = new ArrayList<String>();
    }

    public String toString() {
        Object argumentItems;
        Object dest;
        Collector<CharSequence, ?, String> ioBlocksJoiner = Collectors.joining("][");
        Object sources = this.sourceBlocks.stream().collect(ioBlocksJoiner);
        if (!((String)sources).isEmpty()) {
            sources = "[" + (String)sources + "]";
        }
        if (!((String)(dest = this.destBlocks.stream().collect(ioBlocksJoiner))).isEmpty()) {
            dest = "[" + (String)dest + "]";
        }
        if (!((String)(argumentItems = this.arguments.stream().map(FilterArgument::toString).collect(Collectors.joining(":")))).isEmpty()) {
            argumentItems = "=" + (String)argumentItems;
        }
        return (String)sources + this.filterName + (String)argumentItems + (String)dest;
    }

    public List<String> getDestBlocks() {
        return this.destBlocks;
    }

    public List<String> getSourceBlocks() {
        return this.sourceBlocks;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public List<FilterArgument> getArguments() {
        return this.arguments;
    }

    public int hashCode() {
        return Objects.hash(this.destBlocks, this.arguments, this.filterName, this.sourceBlocks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.destBlocks, other.destBlocks) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.filterName, other.filterName) && Objects.equals(this.sourceBlocks, other.sourceBlocks);
    }

    @Override
    public void setSourceBlocks(List<String> sourceBlocks) {
        this.sourceBlocks = Objects.requireNonNull(sourceBlocks);
    }

    @Override
    public void setDestBlocks(List<String> destBlocks) {
        this.destBlocks = Objects.requireNonNull(destBlocks);
    }

    @Override
    public void setFilterName(String filterName) {
        this.filterName = Objects.requireNonNull(filterName);
    }

    @Override
    public void setArguments(List<FilterArgument> arguments) {
        this.arguments = Objects.requireNonNull(arguments);
    }

    public void addArgument(String key, String value) {
        this.getArguments().add(new FilterArgument(key, value));
    }

    public void addArgument(String key, Number value) {
        this.getArguments().add(new FilterArgument(key, value));
    }

    public void addArgument(String key, Enum<?> value) {
        this.getArguments().add(new FilterArgument(key, value));
    }

    public void addArgument(String key, Collection<?> values, String join) {
        this.getArguments().add(new FilterArgument(key, values, join));
    }

    public void addArgument(String key, Stream<?> values, String join) {
        this.getArguments().add(new FilterArgument(key, values, join));
    }

    public void addArgument(String key) {
        this.getArguments().add(new FilterArgument(key));
    }
}

