/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ffmpeg.ffprobe.StreamType;
import tv.hd3g.fflauncher.FFbase;
import tv.hd3g.fflauncher.InputGeneratorsTraits;
import tv.hd3g.fflauncher.MediaException;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.fflauncher.about.FFAboutCodec;
import tv.hd3g.fflauncher.enums.FFUnit;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class FFmpeg
extends FFbase
implements InputGeneratorsTraits {
    private static final Logger log = LogManager.getLogger();
    private int deviceIdToUse = -1;

    public FFmpeg(String execName, Parameters parameters) {
        super(execName, parameters);
    }

    public FFmpeg addSimpleOutputDestination(String destinationName, String destinationContainer) {
        Objects.requireNonNull(destinationName, "\"destinationName\" can't to be null");
        Objects.requireNonNull(destinationContainer, "\"destinationContainer\" can't to be null");
        String varname = this.getInternalParameters().tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationName, varname, "-f", destinationContainer);
        return this;
    }

    public FFmpeg addSimpleOutputDestination(File destinationFile, String destinationContainer) {
        Objects.requireNonNull(destinationFile, "\"destinationFile\" can't to be null");
        Objects.requireNonNull(destinationContainer, "\"destinationContainer\" can't to be null");
        String varname = this.getInternalParameters().tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationFile, varname, "-f", destinationContainer);
        return this;
    }

    public FFmpeg addFastStartMovMp4File() {
        this.getInternalParameters().addBulkParameters("-movflags faststart");
        return this;
    }

    public FFmpeg addHardwareNVScalerFilter(Point newSize, String pixelFormat, String interpAlgo) {
        StringBuilder scale = new StringBuilder();
        scale.append("scale_npp=");
        scale.append("w=" + newSize.x + ":");
        scale.append("h=" + newSize.y + ":");
        if (pixelFormat != null) {
            scale.append("format=" + pixelFormat + ":");
        }
        if (interpAlgo != null) {
            scale.append("interp_algo=" + interpAlgo);
        }
        log.debug("Add vf: {}", (Object)scale);
        this.getInternalParameters().addParameters(new String[]{"-vf", scale.toString()});
        return this;
    }

    public FFmpeg addHardwareNVMultipleScalerFilterComplex(Map<String, String> configuration) {
        Objects.requireNonNull(configuration, "\"configuration\" can't to be null");
        if (configuration.isEmpty()) {
            throw new IllegalArgumentException("\"configuration\" can't to be empty");
        }
        StringBuilder nvresize = new StringBuilder();
        nvresize.append("nvresize=outputs=" + configuration.size() + ":");
        nvresize.append("size=" + configuration.keySet().stream().collect(Collectors.joining("|")) + ":");
        if (this.deviceIdToUse > -1) {
            nvresize.append("gpu=" + this.deviceIdToUse + ":");
        }
        nvresize.append("readback=0" + configuration.keySet().stream().map(configuration::get).collect(Collectors.joining("", "[", "]")));
        log.debug("Add filter_complex: {}", (Object)nvresize);
        this.getInternalParameters().addParameters(new String[]{"-filter_complex", nvresize.toString()});
        return this;
    }

    public static Optional<StreamType> getFirstVideoStream(FFprobeJAXB analysingResult) {
        Optional<StreamType> oVideoStream = analysingResult.getVideoStreams().findFirst();
        if (oVideoStream.isPresent() && ((StreamType)oVideoStream.get()).getDisposition().getAttachedPic() == 0) {
            return oVideoStream;
        }
        return Optional.empty();
    }

    public FFmpeg setDeviceIdToUse(int deviceIdToUse) {
        this.deviceIdToUse = deviceIdToUse;
        return this;
    }

    public int getDeviceIdToUse() {
        return this.deviceIdToUse;
    }

    public FFmpeg addHardwareVideoDecoding(String source, FFprobeJAXB analysingResult, FFHardwareCodec hardwareCodec, FFAbout about) throws MediaException {
        Optional<String> oSourceCuvidCodecEngine;
        Optional<StreamType> oVideoStream = FFmpeg.getFirstVideoStream(analysingResult);
        if (!oVideoStream.isPresent()) {
            throw new MediaException("Can't found \"valid\" video stream on \"" + source + "\"");
        }
        StreamType videoStream = oVideoStream.get();
        FFAboutCodec codec = about.getCodecs().stream().filter(c -> c.decodingSupported && c.name.equals(videoStream.getCodecName())).findFirst().orElseThrow(() -> new MediaException("Can't found a valid decoder codec for " + videoStream.getCodecName() + " in \"" + source + "\""));
        if (hardwareCodec == FFHardwareCodec.NV && about.isNVToolkitIsAvaliable() && (oSourceCuvidCodecEngine = codec.decoders.stream().filter(decoder -> decoder.endsWith("_cuvid")).findFirst()).isPresent()) {
            ArrayList<String> sourceOptions = new ArrayList<String>();
            if (this.deviceIdToUse > -1) {
                sourceOptions.add("-hwaccel_device");
                sourceOptions.add(Integer.toString(this.deviceIdToUse));
            }
            sourceOptions.add("-hwaccel");
            sourceOptions.add("cuvid");
            sourceOptions.add("-vsync");
            sourceOptions.add("0");
            sourceOptions.add("-c:v");
            sourceOptions.add(oSourceCuvidCodecEngine.get());
            log.debug(() -> "Add hardware decoded source " + sourceOptions.stream().collect(Collectors.joining(" ")) + " -i " + source);
            this.addSimpleInputSource(source, sourceOptions);
            return this;
        }
        throw new MediaException("Can't found a valid hardware decoder on \"" + source + "\" (\"" + videoStream.getCodecLongName() + "\")");
    }

    public FFmpeg addHardwareVideoEncoding(String destCodecName, int outputVideoStreamIndex, FFHardwareCodec hardwareCodec, FFAbout about) throws MediaException {
        if (destCodecName.equals("copy")) {
            throw new MediaException("\"copy\" codec can't be handled by hardware !");
        }
        FFAboutCodec codec = about.getCodecs().stream().filter(c -> c.encodingSupported && c.name.equals(destCodecName)).findFirst().orElseThrow(() -> new MediaException("Can't found a valid codec for " + destCodecName));
        if (hardwareCodec != FFHardwareCodec.NV || !about.isNVToolkitIsAvaliable()) {
            throw new MediaException("Can't found a valid hardware coder to \"" + destCodecName + "\"");
        }
        String coder = codec.encoders.stream().filter(encoder -> encoder.endsWith("_nvenc") || encoder.startsWith("nvenc_") || encoder.equals("nvenc")).findFirst().orElseThrow(() -> new MediaException("Can't found a valid hardware " + hardwareCodec + " codec for " + destCodecName));
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:v:" + outputVideoStreamIndex, coder});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:v", coder});
        }
        return this;
    }

    public FFmpeg addPreset(Preset preset) {
        this.getInternalParameters().addParameters(new String[]{"-preset", preset.toString()});
        return this;
    }

    public FFmpeg addTune(Tune tune) {
        this.getInternalParameters().addParameters(new String[]{"-tune", tune.toString()});
        return this;
    }

    public FFmpeg addBitrate(int bitrate, FFUnit bitrateUnit, int outputVideoStreamIndex) {
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-b:v:" + outputVideoStreamIndex, bitrate + bitrateUnit.toString()});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-b:v", bitrate + bitrateUnit.toString()});
        }
        return this;
    }

    public FFmpeg addBitrateControl(int minRate, int maxRate, int bufsize, FFUnit bitrateUnit) {
        if (minRate > 0) {
            this.getInternalParameters().addParameters(new String[]{"-minrate", minRate + bitrateUnit.toString()});
        }
        if (maxRate > 0) {
            this.getInternalParameters().addParameters(new String[]{"-maxrate", maxRate + bitrateUnit.toString()});
        }
        if (bufsize > 0) {
            this.getInternalParameters().addParameters(new String[]{"-bufsize", bufsize + bitrateUnit.toString()});
        }
        return this;
    }

    public FFmpeg addCRF(int crf) {
        this.getInternalParameters().addParameters(new String[]{"-crf", String.valueOf(crf)});
        return this;
    }

    public FFmpeg addVideoCodecName(String codecName, int outputVideoStreamIndex) {
        if (outputVideoStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:v:" + outputVideoStreamIndex, codecName});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:v", codecName});
        }
        return this;
    }

    public FFmpeg addGOPControl(int b_frames, int gop_size, int ref_frames) {
        if (b_frames > 0) {
            this.getInternalParameters().addParameters(new String[]{"-bf", String.valueOf(b_frames)});
        }
        if (gop_size > 0) {
            this.getInternalParameters().addParameters(new String[]{"-g", String.valueOf(gop_size)});
        }
        if (ref_frames > 0) {
            this.getInternalParameters().addParameters(new String[]{"-ref", String.valueOf(ref_frames)});
        }
        return this;
    }

    public FFmpeg addIBQfactor(float i_qfactor, float b_qfactor) {
        if (i_qfactor > 0.0f) {
            this.getInternalParameters().addParameters(new String[]{"-i_qfactor", String.valueOf(i_qfactor)});
        }
        if (b_qfactor > 0.0f) {
            this.getInternalParameters().addParameters(new String[]{"-b_qfactor", String.valueOf(b_qfactor)});
        }
        return this;
    }

    public FFmpeg addQMinMax(int qmin, int qmax) {
        if (qmin > 0) {
            this.getInternalParameters().addParameters(new String[]{"-qmin", String.valueOf(qmin)});
        }
        if (qmax > 0) {
            this.getInternalParameters().addParameters(new String[]{"-qmax", String.valueOf(qmax)});
        }
        return this;
    }

    public FFmpeg addAudioCodecName(String codecName, int outputAudioStreamIndex) {
        if (outputAudioStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:a:" + outputAudioStreamIndex, codecName});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:a", codecName});
        }
        return this;
    }

    public FFmpeg addVsync(int value) {
        this.getInternalParameters().addParameters(new String[]{"-vsync", String.valueOf(value)});
        return this;
    }

    public FFmpeg addMap(int sourceIndex, int streamIndexInSource) {
        this.getInternalParameters().addParameters(new String[]{"-map", sourceIndex + ":" + streamIndexInSource});
        return this;
    }

    public static enum Tune {
        FILM,
        ANIMATION,
        GRAIN,
        STILLIMAGE,
        PSNR,
        SSIM,
        FASTDECODE,
        ZEROLATENCY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Preset {
        ULTRAFAST,
        SUPERFAST,
        VERYFAST,
        FASTER,
        FAST,
        MEDIUM,
        SLOW,
        SLOWER,
        VERYSLOW,
        PLACEBO;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum FFHardwareCodec {
        NV;

    }
}

