/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFmpeg;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class GenerateVideoFile {
    private final String execName;
    private final ExecutableFinder executableFinder;

    public GenerateVideoFile(ExecutableFinder executableFinder) {
        this("ffmpeg", executableFinder);
    }

    public GenerateVideoFile(String execName, ExecutableFinder executableFinder) {
        this.execName = Objects.requireNonNull(execName);
        this.executableFinder = Objects.requireNonNull(executableFinder);
    }

    private FFmpeg internal(int duration_in_sec, Point resolution) throws IOException {
        Parameters parameters = new Parameters();
        FFmpeg ffmpeg = new FFmpeg(this.execName, parameters);
        FFAbout about = ffmpeg.getAbout(this.executableFinder);
        if (!about.isFromFormatIsAvaliable("lavfi")) {
            File exec = this.executableFinder.get(ffmpeg.getExecutableName());
            throw new IOException("This ffmpeg (" + exec + ") can't handle \"lavfi\"");
        }
        ffmpeg.setOverwriteOutputFiles();
        ffmpeg.setOnErrorDeleteOutFiles(true);
        ffmpeg.setFilterForLinesEventsToDisplay(l -> !l.isStdErr() || l.isStdErr() && ffmpeg.filterOutErrorLines().test(l.getLine()));
        parameters.addBulkParameters("-f lavfi -i smptehdbars=duration=" + duration_in_sec + ":size=" + resolution.x + "x" + resolution.y + ":rate=25");
        parameters.addBulkParameters("-f lavfi -i sine=frequency=1000:sample_rate=48000:duration=" + duration_in_sec);
        if (about.isCoderIsAvaliable("h264")) {
            ffmpeg.addVideoCodecName("h264", -1).addCRF(1);
        } else {
            ffmpeg.addVideoCodecName("ffv1", -1);
        }
        if (about.isCoderIsAvaliable("aac")) {
            ffmpeg.addAudioCodecName("aac", -1);
        } else {
            ffmpeg.addAudioCodecName("opus", -1);
        }
        return ffmpeg;
    }

    public FFmpeg generateBarsAnd1k(String destination, int duration_in_sec, Point resolution) throws IOException {
        FFmpeg ffmpeg = this.internal(duration_in_sec, resolution);
        ffmpeg.addSimpleOutputDestination(destination);
        ffmpeg.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        ffmpeg.execute(this.executableFinder).waitForEndAndCheckExecution();
        return ffmpeg;
    }

    public FFmpeg generateBarsAnd1k(File destination, int duration_in_sec, Point resolution) throws IOException {
        FFmpeg ffmpeg = this.internal(duration_in_sec, resolution);
        ffmpeg.addSimpleOutputDestination(destination);
        ffmpeg.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        ffmpeg.execute(this.executableFinder).waitForEndAndCheckExecution();
        return ffmpeg;
    }
}

