/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFbase;
import tv.hd3g.fflauncher.about.FFAbout;
import tv.hd3g.fflauncher.about.FFAboutFilter;
import tv.hd3g.fflauncher.enums.FilterConnectorType;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.parser.FilterParser;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class FilterChains {
    private final List<List<Filter>> chain;

    public FilterChains() {
        this.chain = new ArrayList<List<Filter>>();
    }

    public FilterChains(String filterChain) {
        this.chain = FilterParser.fullParsing(filterChain, Filter::new);
    }

    public void addFilterInLastChain(Filter filter, boolean createNewChain) {
        if (createNewChain || this.chain.isEmpty()) {
            this.createChain().add(filter);
        } else {
            this.chain.get(this.chain.size() - 1).add(filter);
        }
    }

    public Filter addFilterInLastChain(String rawFilter, boolean createNewChain) {
        Filter filter = new Filter(rawFilter);
        this.addFilterInLastChain(filter, createNewChain);
        return filter;
    }

    public List<Filter> insertFilterInChain(Filter filter, Filter previousFilter) {
        List currentChain = this.chain.stream().filter(c -> c.contains(previousFilter)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't found filter \"" + previousFilter + "\" declared is actual chains"));
        int actualPos = currentChain.indexOf(previousFilter);
        if (actualPos + 1 == currentChain.size()) {
            currentChain.add(filter);
        } else {
            currentChain.add(actualPos + 1, filter);
        }
        return currentChain;
    }

    public List<Filter> getLastChain() {
        return this.chain.get(this.chain.size() - 1);
    }

    public List<Filter> insertFilterInChain(String rawFilter, Filter previousFilter) {
        return this.insertFilterInChain(new Filter(rawFilter), previousFilter);
    }

    public int getChainsCount() {
        return this.chain.size();
    }

    public List<Filter> getChain(int chainId) {
        return this.chain.get(chainId);
    }

    public List<Filter> createChain() {
        ArrayList<Filter> newChain = new ArrayList<Filter>();
        this.chain.add(newChain);
        return newChain;
    }

    public void removeChain(int chainId) {
        this.chain.remove(chainId);
    }

    public void pushFilterChainTo(String parameterName, FFbase ffbase) {
        ffbase.getInternalParameters().addParameters(new String[]{parameterName, this.toString()});
    }

    public void setFilterChainToVar(String varName, FFbase ffbase) {
        if (this.getChainsCount() > 0) {
            ffbase.getParametersVariables().put(varName, Parameters.of((String[])new String[]{this.toString()}));
        }
    }

    public static List<FilterChains> parse(String parameterName, Parameters parameters) {
        return Optional.ofNullable(parameters.getValues(parameterName)).orElse(List.of()).stream().map(FilterChains::new).collect(Collectors.toUnmodifiableList());
    }

    public static List<FilterChains> parse(String parameterName, ConversionTool conversionTool) {
        return FilterChains.parse(parameterName, conversionTool.getInternalParameters());
    }

    public static FilterChains merge(List<FilterChains> chainsList) {
        FilterChains item = new FilterChains();
        chainsList.stream().map(fc -> fc.chain).forEach(item.chain::addAll);
        return item;
    }

    public static List<FilterChains> parseFromReadyToRunParameters(String parameterName, ConversionTool conversionTool) {
        return FilterChains.parse(parameterName, conversionTool.getReadyToRunParameters());
    }

    public String toString() {
        return this.chain.stream().map(filters -> filters.stream().map(Filter::toString).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
    }

    public List<Filter> checkFiltersAvailability(FFAbout about) {
        return this.checkFiltersAvailability(about, null);
    }

    public List<Filter> checkFiltersAvailability(FFAbout about, FilterConnectorType expectedType) {
        List<FFAboutFilter> filters = about.getFilters();
        Set availableFilters = filters.stream().filter(f -> {
            if (expectedType == null) {
                return true;
            }
            return expectedType.equals((Object)f.getSourceConnector());
        }).map(FFAboutFilter::getTag).distinct().collect(Collectors.toUnmodifiableSet());
        return this.chain.stream().flatMap(Collection::stream).filter(filter -> !availableFilters.contains(filter.getFilterName())).collect(Collectors.toUnmodifiableList());
    }
}

