/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.FilterArgument;

public class AudioFilterChannelmap {
    private final ChannelLayout destChannelLayout;
    private final Map<Channel, Channel> channelMap;

    public AudioFilterChannelmap(ChannelLayout destChannelLayout, Map<Channel, Channel> channelMap) {
        this.destChannelLayout = destChannelLayout;
        this.channelMap = channelMap;
        List<Channel> destChList = destChannelLayout.getChannelList();
        boolean invalidMapEntry = channelMap.keySet().stream().anyMatch(c -> !destChList.contains(c));
        if (invalidMapEntry) {
            throw new IllegalArgumentException("Invalid channelMap (" + channelMap + "), it contain missing channels from " + destChannelLayout);
        }
    }

    public Filter toFilter() {
        String map = this.destChannelLayout.getChannelList().stream().filter(this.channelMap::containsKey).map(destCh -> (Object)((Object)this.channelMap.get(destCh)) + "-" + destCh).collect(Collectors.joining("|"));
        return new Filter("channelmap", new FilterArgument("map", map), new FilterArgument("channel_layout", this.destChannelLayout));
    }
}

