/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.acm.ACMAudioStream;
import tv.hd3g.fflauncher.acm.InputAudioChannelSelector;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;

public class InputAudioStream
extends ACMAudioStream {
    public InputAudioStream(ChannelLayout layout, int fileIndex, int streamIndex) {
        super(layout, fileIndex, streamIndex);
    }

    @Override
    public String toMapReferenceAsInput() {
        return this.getFileIndex() + ":" + this.getStreamIndex();
    }

    public String toString() {
        return this.toMapReferenceAsInput() + "(" + this.getLayout() + ")";
    }

    public static List<InputAudioStream> getListFromAnalysis(FFprobeJAXB ... sourcesAnalysis) {
        for (int pos = 0; pos < sourcesAnalysis.length; ++pos) {
            Objects.requireNonNull(sourcesAnalysis[pos]);
        }
        return InputAudioStream.getListFromAnalysis(List.of(sourcesAnalysis));
    }

    public static List<InputAudioStream> getListFromAnalysis(List<FFprobeJAXB> sourcesAnalysis) {
        ArrayList allSourceStreams = new ArrayList();
        int pos = 0;
        while (pos < sourcesAnalysis.size()) {
            FFprobeJAXB analysis = sourcesAnalysis.get(pos);
            int absoluteSourceIndex = pos++;
            analysis.getAudiosStreams().sorted((l, r) -> Integer.compare(l.getIndex(), r.getIndex())).map(as -> {
                String layout = as.getChannelLayout();
                if (layout == null || layout.isEmpty()) {
                    return new InputAudioStream(ChannelLayout.getByChannelSize(as.getChannels()), absoluteSourceIndex, as.getIndex());
                }
                return new InputAudioStream(ChannelLayout.parse(layout), absoluteSourceIndex, as.getIndex());
            }).forEach(allSourceStreams::add);
        }
        return Collections.unmodifiableList(allSourceStreams);
    }

    public static InputAudioStream getFromRelativeIndexes(List<InputAudioStream> streamList, int fileIndex, int audioStreamRelativeIndex) {
        List streamsInFile = streamList.stream().filter(inStream -> inStream.getFileIndex() == fileIndex).collect(Collectors.toUnmodifiableList());
        for (int pos = 0; pos < streamsInFile.size(); ++pos) {
            if (pos != audioStreamRelativeIndex) continue;
            return (InputAudioStream)streamsInFile.get(pos);
        }
        return null;
    }

    public static SelectedInputChannel getFromAbsoluteIndex(List<InputAudioStream> streamList, int channelIndex) {
        int totalChannelCount = 0;
        Iterator<InputAudioStream> iterator = streamList.iterator();
        while (iterator.hasNext()) {
            int relativeChannelIndex = channelIndex - totalChannelCount;
            InputAudioStream inStream = iterator.next();
            ChannelLayout layout = inStream.getLayout();
            int layoutSize = layout.getChannelSize();
            if (relativeChannelIndex < layoutSize) {
                InputAudioStream inputAudioStream = inStream;
                Objects.requireNonNull(inputAudioStream);
                return inputAudioStream.new SelectedInputChannel(inStream, new InputAudioChannelSelector(relativeChannelIndex));
            }
            totalChannelCount += layoutSize;
        }
        return null;
    }

    public class SelectedInputChannel {
        private final InputAudioStream inputAudioStream;
        private final InputAudioChannelSelector channelSelector;

        SelectedInputChannel(InputAudioStream inputAudioStream, InputAudioChannelSelector channelSelector) {
            this.inputAudioStream = inputAudioStream;
            this.channelSelector = channelSelector;
        }

        InputAudioStream getInputAudioStream() {
            return this.inputAudioStream;
        }

        InputAudioChannelSelector getChannelSelector() {
            return this.channelSelector;
        }
    }
}

