/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.acm.ACMExportableMapReference;
import tv.hd3g.fflauncher.acm.ACMListIndexPositionHandler;
import tv.hd3g.fflauncher.acm.OutputAudioStream;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.AudioFilterAmerge;
import tv.hd3g.fflauncher.filtering.AudioFilterJoin;
import tv.hd3g.fflauncher.filtering.Filter;

class ACMMergeJoinToStreamDefinitionFilter
extends ACMListIndexPositionHandler {
    private final List<ACMExportableMapReference> inputs;
    private final OutputAudioStream toOutput;

    ACMMergeJoinToStreamDefinitionFilter(List<ACMExportableMapReference> inputs, OutputAudioStream toOutput) {
        this.inputs = Objects.requireNonNull(inputs);
        this.toOutput = Objects.requireNonNull(toOutput);
    }

    @Override
    public String toMapReferenceAsInput() {
        return "mergjoin" + this.absolutePosIndex;
    }

    @Override
    public OutputAudioStream getLinkableOutStreamReference() {
        return this.toOutput;
    }

    @Override
    public String toString() {
        String inRefs = this.inputs.stream().map(ACMExportableMapReference::toMapReferenceAsInput).collect(Collectors.joining("+"));
        return inRefs + ">~" + this.toMapReferenceAsInput() + "(" + this.toOutput.getLayout() + ")";
    }

    List<ACMExportableMapReference> getInputs() {
        return this.inputs;
    }

    private void internalCheck() {
        int inChCount = this.inputs.size();
        int outChCount = this.toOutput.getLayout().getChannelList().size();
        if (inChCount == 0) {
            throw new IllegalArgumentException("No inputs for filter " + this.toOutput.toMapReferenceAsInput());
        }
        if (inChCount != outChCount) {
            throw new IllegalArgumentException("Invalid input stream count (" + inChCount + ") for filter " + this.toOutput.toMapReferenceAsInput() + " with expected " + outChCount + " audio channels");
        }
    }

    public Filter toAmergeFilter() {
        this.internalCheck();
        Filter filter = new AudioFilterAmerge(this.inputs.size()).toFilter();
        filter.setSourceBlocks(this.inputs.stream().map(ACMExportableMapReference::toMapReferenceAsInput).collect(Collectors.toUnmodifiableList()));
        filter.setDestBlocks(List.of(this.toMapReferenceAsInput()));
        return filter;
    }

    public Filter toJoinFilter() {
        this.internalCheck();
        ChannelLayout layout = this.toOutput.getLayout();
        LinkedHashMap<Channel, CallSite> sourceByDestChannel = new LinkedHashMap<Channel, CallSite>(this.inputs.size());
        List<Channel> channelList = layout.getChannelList();
        for (int pos = 0; pos < channelList.size(); ++pos) {
            sourceByDestChannel.put(channelList.get(pos), (CallSite)((Object)(pos + ".0")));
        }
        Filter filter = new AudioFilterJoin(this.inputs.size(), layout, Collections.unmodifiableMap(sourceByDestChannel)).toFilter();
        filter.setSourceBlocks(this.inputs.stream().map(ACMExportableMapReference::toMapReferenceAsInput).collect(Collectors.toUnmodifiableList()));
        filter.setDestBlocks(List.of(this.toMapReferenceAsInput()));
        return filter;
    }
}

