/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFprobe;
import tv.hd3g.fflauncher.enums.FFLogLevel;
import tv.hd3g.fflauncher.recipes.Recipe;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.tool.ExecutableTool;
import tv.hd3g.processlauncher.tool.ToolRunner;

public class ProbeMedia
extends Recipe {
    private static Logger log = LogManager.getLogger();
    private final ScheduledExecutorService maxExecTimeScheduler;

    public ProbeMedia(ToolRunner toolRun, ScheduledExecutorService maxExecTimeScheduler) {
        super(toolRun, "ffprobe");
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
    }

    public ProbeMedia(ToolRunner toolRun, String execName, ScheduledExecutorService maxExecTimeScheduler) {
        super(toolRun, execName);
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
    }

    private FFprobe internal() {
        Parameters parameters = new Parameters();
        FFprobe ffprobe = new FFprobe(this.execName, parameters);
        ffprobe.setPrintFormat(FFprobe.FFPrintFormat.XML).setShowStreams().setShowFormat().setShowChapters().isHidebanner();
        ffprobe.setMaxExecTimeScheduler(this.maxExecTimeScheduler);
        ffprobe.setLogLevel(FFLogLevel.ERROR, false, false);
        ffprobe.setFilterForLinesEventsToDisplay(l -> l.isStdErr() && ffprobe.filterOutErrorLines().test(l.getLine()));
        return ffprobe;
    }

    private FFprobeJAXB execute(FFprobe ffprobe) {
        ToolRunner.RunningTool rtFFprobe = this.toolRun.execute((ExecutableTool)ffprobe);
        CapturedStdOutErrTextRetention textRetention = rtFFprobe.checkExecutionGetText();
        String stdOut = textRetention.getStdout(false, System.lineSeparator());
        return new FFprobeJAXB(stdOut, warn -> log.warn(warn));
    }

    public FFprobeJAXB doAnalysing(String source) {
        FFprobe ffprobe = this.internal();
        ffprobe.addSimpleInputSource(source, new String[0]);
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        return this.execute(ffprobe);
    }

    public FFprobeJAXB doAnalysing(File source) {
        FFprobe ffprobe = this.internal();
        ffprobe.addSimpleInputSource(source, new String[0]);
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        return this.execute(ffprobe);
    }
}

