/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.acm.ACMAudioChannelSelector;
import tv.hd3g.fflauncher.acm.ACMListIndexPositionHandler;
import tv.hd3g.fflauncher.acm.InputAudioChannelSelector;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioStream;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.AudioFilterChannelsplit;
import tv.hd3g.fflauncher.filtering.Filter;

class ACMSplitInStreamDefinitionFilter {
    private final InputAudioStream inputAudioStream;
    private final Map<InputAudioChannelSelector, SplittedOut> splittedOut;

    ACMSplitInStreamDefinitionFilter(OutputAudioStream.OutputAudioChannel firstOutChannel, int firstSplittedOutAbsolutePosIndex) {
        this.inputAudioStream = firstOutChannel.getInputAudioStream();
        InputAudioChannelSelector firstChInIndex = firstOutChannel.getChInIndex();
        this.splittedOut = new LinkedHashMap<InputAudioChannelSelector, SplittedOut>(Map.of(firstChInIndex, new SplittedOut(firstOutChannel, firstSplittedOutAbsolutePosIndex)));
    }

    public String toString() {
        return this.inputAudioStream + "~>" + this.splittedOut;
    }

    InputAudioStream getInputAudioStream() {
        return this.inputAudioStream;
    }

    Map<InputAudioChannelSelector, SplittedOut> getSplittedOut() {
        return this.splittedOut;
    }

    Filter toFilter() {
        ChannelLayout inputLayout = this.inputAudioStream.getLayout();
        List<Channel> inputLayoutChannelList = inputLayout.getChannelList();
        List<Channel> selectedChannels = this.splittedOut.keySet().stream().sorted().map(ACMAudioChannelSelector::getPosInStream).map(inputLayoutChannelList::get).collect(Collectors.toUnmodifiableList());
        Filter filter = new AudioFilterChannelsplit(inputLayout, selectedChannels).toFilter();
        filter.getSourceBlocks().add(this.inputAudioStream.toMapReferenceAsInput());
        filter.getDestBlocks().addAll(this.splittedOut.keySet().stream().sorted().map(this.splittedOut::get).map(SplittedOut::toMapReferenceAsInput).collect(Collectors.toUnmodifiableList()));
        return filter;
    }

    class SplittedOut
    extends ACMListIndexPositionHandler {
        private final OutputAudioStream.OutputAudioChannel outputAudioChannel;

        SplittedOut(OutputAudioStream.OutputAudioChannel outputAudioChannel, int absolutePosIndex) {
            this.outputAudioChannel = outputAudioChannel;
            this.absolutePosIndex = absolutePosIndex;
            if (!outputAudioChannel.getInputAudioStream().equals(ACMSplitInStreamDefinitionFilter.this.inputAudioStream)) {
                throw new IllegalArgumentException("Can't mix inputAudioStream sources (" + outputAudioChannel.getInputAudioStream() + "/" + ACMSplitInStreamDefinitionFilter.this.inputAudioStream + ")");
            }
        }

        @Override
        public String toMapReferenceAsInput() {
            return "split" + this.absolutePosIndex;
        }

        @Override
        public OutputAudioStream getLinkableOutStreamReference() {
            return this.outputAudioChannel.getOutputAudioStream();
        }

        InputAudioStream getInStream() {
            return ACMSplitInStreamDefinitionFilter.this.inputAudioStream;
        }

        OutputAudioStream.OutputAudioChannel getOutputAudioChannel() {
            return this.outputAudioChannel;
        }
    }
}

